"use strict";
const { S3 } = require("aws-sdk");
const uuid = require("short-uuid");

const uploadToS3 = async (file) => {
  try {
    const s3 = new S3();
    const params = {
      Bucket: process.env.AWS_BUCKET_NAME,
      Key: `${file.folderName}/` + `${uuid.generate()}-${file.originalname}`,
      Body: file.buffer,
      acl: "public-read",
    };
    const uploadToBucket = await s3.upload(params).promise();
    return uploadToBucket;
  } catch (error) {
    throw new Error("Error in s3 config => " + error);
  }
};

const deleteFromS3 = async (filePathToDelete) => {
  try {
    const s3 = new S3();
    const params = {
      Bucket: process.env.AWS_BUCKET_NAME,
      Key: filePathToDelete,
    };
    const deleteFromBucket = await s3.deleteObject(params).promise();
    return deleteFromBucket;
  } catch (error) {
    throw new Error("Error in s3 config => " + error);
  }
};

module.exports = {
  uploadToS3,
  deleteFromS3,
};
