const multer = require("multer");
const tryCatch = require("../utils/tryCatch");
const { uploadToS3, deleteFromS3 } = require("../aws/aws.config");

const fileFilter = (req, file, cb) => {
  const fileType = file.mimetype.split("/")[0];
  switch (fileType) {
    case "image":
        file["folderName"] = "images"; 
      cb(null, true);
      break;

    case "text":
    case "application":
      file["folderName"] = "files";
      cb(null, true);
      break;

    default:
      cb(new Error("This file type is not accepted!"));
      break;
  }
};
const storage = multer.memoryStorage();
const upload = multer({
  fileFilter,
  storage,
  limits: {
    fileSize: 1024 * 1024 * 10, // 10MB
    files: 1,
  },
});

const uploadFilesToS3Bucket = tryCatch(async (req, res) => {
// console.log("req.body",req.body.destination)
   
  if (!req.file) {
    throw new Error("No file to upload!");
  }

  if(req.body.destination){
    req.file["folderName"] = "images/"+req.body.destination; 
  }
  
  const uploadFile = await uploadToS3(req.file);
  if (!uploadFile) throw new Error("Error in uploading file to S3 bucket!");
  return res.status(200).json({
    message: "File uploaded successfully!",
    access_url: uploadFile.Location,
  });
});

const deleteFilesFromS3Bucket = tryCatch(async (req, res) => {
  const { fileUrl } = req.body;
  if (!fileUrl) {
    throw new Error("No file name to delete!");
  }

  const senitizedFile = getSenitizedFileInfoFromUrl(fileUrl);

  const deleteFile = await deleteFromS3(senitizedFile);
  if (!deleteFile) throw new Error("Error in deleting file from S3 bucket!");
  return res.status(200).json({
    message: "File deleted successfully!",
  });
});

const getSenitizedFileInfoFromUrl = (url) => {
  const fileUrl = (new URL(url)).pathname.split("/");
  const fileName = decodeURIComponent(fileUrl[2]);
  const folderName = fileUrl[1];
  if(!folderName || !fileName) throw new Error("Invalid url!")
  return folderName + "/" + fileName;
};

module.exports = {
  upload,
  uploadFilesToS3Bucket,
  deleteFilesFromS3Bucket,
};
