var mysql = require("mysql");

// const { host, user, password, database,  SERVICE_PROVIDER, NODE_ENV } =
//   process.env;

// const host = 'localhost'
// const user = 'root'
// const password = ''
// const database = 'bharat_invits'


const host = 'localhost'
const user = 'allschoolscolleg_sv_user'
const password = 'xDrekOsw(U=H'
const database = 'allschoolscolleg_sv_DB'






  
var con = mysql.createPool({
  host,
  user,
  password,
  database,
  
  connectionLimit: 30,
  queueLimit: 200,
  waitForConnections: true,
  ssl: false,
});

//connectDB establishes a connection to a MySQL database using the connection configuration specified in the con object.
//It logs a message to the console if the connection is successful or if an error occurs.
const connectDB = () => {
  return new Promise((resolve, reject) => {
    con.getConnection((err, connection) => {
      if (err) {
        console.log("Error connecting to the database:", err);
        return reject(err);
      }
      try {
        console.log("Connected to the database");
        console.log("Service Provider:", SERVICE_PROVIDER);
        console.log("NODE_ENV:", NODE_ENV);
        resolve(connection);
      } finally {
        connection.release();
      }
    });
  });
};

//dbQuery is an async function that takes an SQL string sql and an optional content parameter.
//It returns a promise that resolves with the result of the query or rejects with an error if one occurs.
const dbQuery = (sql, content) => {
  return new Promise((resolve, reject) => {
    con.getConnection((err, connection) => {
      if (err) {
        console.log("Error connecting to the database:", err);
        return reject(err);
      }
      try {
        connection.beginTransaction();
        con.query(sql, content, (err, result) => {
          if (err) {
            console.log("Error on the database query:", sql, content, err);
            connection.rollback();
            return reject(err);
          }
          connection.commit();
          resolve(result);
        });
      } catch (err) {
        connection.rollback();
        reject(err);
      } finally {
        connection.release();
      }
    });
  });
};

//The reconnectToDB function is called when the database connection is lost.
const reconnectToDB = async () => {
  await con.connect((err) => {
    if (err) {
      console.log("Error connecting to the database:", err);
      process.exit(0);
    }
    console.log("Successfully reconnected to the database");
  });
};

//The reconnectToDB function is called when the database connection is lost.
con.on("error", (err) => {
  console.error("Error on the database connection:", err);
  if (err.code === "PROTOCOL_CONNECTION_LOST") {
    console.log(
      "Connection to the database was lost. Attempting to reconnect..."
    );
    reconnectToDB();
  }
});

//The exitHandler function is set up to handle the exit event of the process object,
// which is emitted when the Node.js process is about to exit. If the shutdownDb option is truthy,
//the function logs a message and closes the database connection by calling con.end().
//Finally, the process exits with an exit code of 1.
const exitHandler = (options, exitCode) => {
  if (options.shutdownDb) {
    console.log("\nShutting down... DATABASE");
    con.end();
    process.exit(0);
  }
};
process.on("SIGINT", exitHandler.bind(null, { shutdownDb: true }));

const getSqlQuery = (
  { attributes = [], conditions = [], additional = [], joinTbl = [], distinctAttributes = false },
  TABLE
) => {
  if (!TABLE) throw new Error("Table name is required");
  if(attributes.length === 0) throw new Error("Attributes are required");

  // console.log("aaaaaasasas",`SELECT ${distinctAttributes ? "DISTINCT" : ""}  ${attributes.join(", ")} FROM ${TABLE} ${joinTbl.join(
  //   " "
  // )} WHERE 1=1 ${conditions.length ? " AND " + conditions.join(" AND ") : ""} ${additional.join(" ")}`);

  return `SELECT ${distinctAttributes ? "DISTINCT" : ""}  ${attributes.join(", ")} FROM ${TABLE} ${joinTbl.join(
    " "
  )} WHERE 1=1 ${conditions.length ? " AND " + conditions.join(" AND ") : ""} ${additional.join(" ")}`;

 
  
};

const getSqlQueryForCount = (
  { conditions = [], joinTbl = [], distinctCount = null },
  TABLE
) => {
  if (!TABLE) throw new Error("Table name is required");
  return `SELECT ${distinctCount ? `COUNT(DISTINCT ${distinctCount})` : `COUNT(*)`} as total FROM ${TABLE} ${joinTbl.join(" ")} WHERE 1=1 ${conditions.length ? " AND " + conditions.join(" AND ") : ""}`;
}

const addSqlQuery = ({ attributes = [] }, TABLE) => {
  if (!TABLE) throw new Error("Table name is required");
  if(attributes.length === 0) throw new Error("Attributes are required");
  const values = Array.from({ length: attributes.length }, (_, i) => "?");
  return `INSERT INTO ${TABLE} (${attributes.join(", ")}) VALUES (${values.join(", ")})`;
};

const deleteSqlQuery = ({ conditions = [] }, TABLE) => {
  if (!TABLE) throw new Error("Table name is required");
  if(conditions.length === 0) throw new Error("Conditions are required");
  return `DELETE FROM ${TABLE} WHERE ${conditions.join(" AND ")}`;
};

const updateSqlQuery = ({ update, conditions = [] }, TABLE) => {
  if (!TABLE) throw new Error("Table name is required");
  if(conditions.length === 0) throw new Error("Conditions are required");
  if(update.length === 0) throw new Error("Update data is required");
  return `UPDATE ${TABLE} SET ${update} WHERE ${conditions.join(" AND ")}`;
};

//This code exports two functions: connectDB and dbQuery.
module.exports = { connectDB, dbQuery, getSqlQuery, addSqlQuery, deleteSqlQuery, updateSqlQuery, getSqlQueryForCount };
