const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { postUrlExist, urlExist } = require("../../../../utils/url_exist");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { SC_ARTICLES_CATEGORY } = require("../../../../models/tables");
const { articleCatergoryFields, articleCatergoryMadatoryFields } = require("./create_article_content");

const table = SC_ARTICLES_CATEGORY;

// @desc get articles category
// @api GET api/v1/admin/article-category
// @access private
const get_articleCategory = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let qry = "";
  let { search = "", id } = req.query;
  if (search) qry += `WHERE nc_name LIKE '%${search}%'`;
  let attributes = [
    `${table}.nc_name`,
    `${table}.nc_priority`,
    `${table}.nc_active`,
    `${table}.nc_front_url`,
    `${table}.date_modified`,
    `${table}.nc_id`,
  ];
  if (id) {
    attributes = [`${table}.*`];
    qry = `WHERE nc_id = ${id} LIMIT 1`;
  }
  sql = `SELECT ${attributes.join(", ")} FROM ${table} ${qry}`;
  result = await dbQuery(sql);
  if (result.length === 0) errorMsgEmpty("No data found", res);
  if (id) return res.status(200).json({ success: true, data: result[0] });
  res.status(200).json({ succuss: true, data: result });
});

// @desc add articles category
// @api POST api/v1/admin/article-category
// @access private ADMIN
const post_articleCategory = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const attributes = [];
  const insertBody = [];
  articleCatergoryFields.forEach((field) => {
    if(req.body[field]){
      attributes.push(field);
      insertBody.push(req.body[field]);
    }
    if(articleCatergoryMadatoryFields.includes(field) && !req.body[field]){
      throw new Error(`${field} is required`)
    }
  });

  await postUrlExist(table, "nc_front_url", req.body["nc_front_url"]);
  sql = `INSERT INTO ${table} (${attributes.join(", ")}, date_modified) VALUES ( ${insertBody.map(item => '?')}, NOW())`;
  result = await dbQuery(sql, insertBody);
  if (result.affectedRows === 0)
    throw new Error("Failed to add article category");
  res
    .status(200)
    .json({ success: true, messsage: `Article category added successfully` });
});

// @desc update articles category
// @api PUT api/v1/admin/article-category
// @access private ADMIN
const update_articleCategory = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { nc_id, update } = req.body;
  if (!nc_id || !update) throw new Error("No id or update found");
  await urlExist(table, "nc_id", "nc_front_url", update?.nc_front_url, nc_id);
  const { column, value } = updateColumn(update);
  sql = `UPDATE ${table} SET ${column}, date_modified = NOW() WHERE nc_id = ?`;
  result = await dbQuery(sql, [...value, nc_id]);
  if (result.affectedRows === 0)
    throw new Error("Failed to update article category");
  res
    .status(200)
    .json({ success: true, messsage: "Article category updated successfully" });
});

// @desc delete articles category
// @api DELETE api/v1/admin/article-category
// @access private ADMIN
const del_articleCategory = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { nc_id } = req.body;
  if (!nc_id) throw new Error("No id found");
  sql = `DELETE FROM ${table} WHERE nc_id = ?`;
  result = await dbQuery(sql, [nc_id]);
  if (result.affectedRows === 0)
    throw new Error("Failed to delete article category");
  res
    .status(200)
    .json({ success: true, messsage: "Article category deleted successfully" });
});

module.exports = {
  get_articleCategory,
  post_articleCategory,
  update_articleCategory,
  del_articleCategory,
};
