const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { C_ADDITIONAL } = require("../../../../models/tables");

const table = C_ADDITIONAL;

// @desc    Add Additional Details
// @api   POST /api/v1/admin/college-additional/:e_id
// @access  Private
const get_additionalDetails = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { e_id } = req.params;
  if (!e_id) throw new Error(`No e_id in params`);
  sql = `SELECT * FROM ${table} WHERE e_id = ?`;
  result = await dbQuery(sql, [e_id]);
  if (result.length === 0) errorMsgEmpty("No data found", res);
  return res.status(200).json({ success: true, data: result[0] });
});

// @desc post new details based on e_id
// @api POST /api/v1/admin/college-additional/:e_id
// @access Private ADMIN
const post_additonalDetails = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { e_id } = req.params;
  if (!e_id) throw new Error(`No e_id in params`);
  const {
    photo = null,
    about_institute = null,
    institute_description = null,
    ranking = null,
    placement = null,
    recruiting_company = null,
    infrastructure = null,
    hostel = null,
    faculty = null,
    campus_size = null,
    place_ratio = null,
    place_mid_salary = null,
    exam_acpt = null,
    added_by,
    updated_by,
  } = req.body;
  if (!about_institute || !institute_description)
    throw new Error(" Tells us more about institute and description");
  sql = `INSERT INTO ${table}(e_id,photo,about_institute,institute_description,ranking,placement,recruiting_company,infrastructure,hostel,faculty,campus_size,place_ratio,place_mid_salary,exam_acpt,added_by,updated_by,insert_date,update_date) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?)`;
  result = await dbQuery(sql, [
    e_id,
    photo,
    about_institute,
    institute_description,
    ranking,
    placement,
    recruiting_company,
    infrastructure,
    hostel,
    faculty,
    campus_size,
    place_ratio,
    place_mid_salary,
    exam_acpt,
    "admin", // added_by
    "admin", // updated_by
    // insert_date
    null, // update_date
  ]);
  if (!result.affectedRows) throw new Error("Cannot add additional details");
  return res
    .status(200)
    .json({ success: true, message: `Additional details added for ${e_id}` });
});

// @desc update details based on e_id
// @api PUT /api/v1/admin/college-additional/:e_id
// @access Private ADMIN
const update_additionalDetails = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { e_id } = req.params;
  const { a_id, update } = req.body;
  if (!e_id || !a_id || !update)
    throw new Error("No e_id or a_id or update in body");
  const { column, value } = updateColumn(update);
  sql = `UPDATE ${table} SET ${column}, update_date = NOW() WHERE e_id = ? AND a_id = ?`;
  result = await dbQuery(sql, [...value, e_id, a_id]);
  if (!result.affectedRows) throw new Error("Cannot update additional details");
  return res
    .status(200)
    .json({ success: true, message: `Additional details updated for ${e_id}` });
});

// @desc delete details based on e_id
// @api DELETE /api/v1/admin/college-additional/:e_id
// @access Private ADMIN
const del_additionalDetails = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { e_id } = req.params;
  const { a_id } = req.body;
  if (!e_id || !a_id) throw new Error("No e_id or a_id in body");
  sql = `DELETE FROM ${table} WHERE e_id = ? AND a_id = ?`;
  result = await dbQuery(sql, [e_id, a_id]);
  if (!result.affectedRows) throw new Error("Cannot delete additional details");
  return res
    .status(200)
    .json({ success: true, message: `Additional details deleted for ${e_id}` });
});

module.exports = {
  get_additionalDetails,
  post_additonalDetails,
  update_additionalDetails,
  del_additionalDetails,
};
