const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { urlExist, postUrlExist } = require("../../../../utils/url_exist");
const {
  C_INSTITUTE,
  C_CONTACT,
  C_MEDIA,
  C_COURSE,
  C_ADDITIONAL,
  STATE_TBL,
  CITY_TBL
} = require("../../../../models/tables");
const { collegeCreateFields } = require("./create_college_content");
const {
  getCollegeService,
  getCollegePaginationService,
  addNewCollegeService,
  addNewCollegeAdditionalDetailsService,
  addNewCollegecontactDetailsService,
  addNewCollegeImageService,
  deleteCollegeService,
  updateCollegeService, getCollegesCourseService} = require("../../../../services/college.service");
const { areAllKeysPresent } = require("../../../../utils/common_utils");


//@desc get one college details
// @api GET api/v1/admin/college-details/:e_id
// @access private ADMIN
const getCollegeDetailsById = tryCatch(async (req, res) => {
  const { e_id } = req.params;
  if (!e_id) throw new Error("Please provide e_id");

  const queryMap = {
    attributes: [`${C_INSTITUTE}.*`],
    conditions: [`${C_INSTITUTE}.e_id = ?`],
    parameters: [e_id],
    additional: [`LIMIT 1`],
  };

  const result = await getCollegeService(queryMap);
  if (result instanceof Error || !result[0]) {
    res.statusCode = 400;
    throw new Error("No data found");
  }

  return res.status(200).json({
    success: true,
    data: result.pop(),
  });
});

// @desc Get College Details
// @route GET /api/v1/college-details
// @access Private ADMIN
const get_collegeDetails = tryCatch(async (req, res) => {

  const { page = 1, limit = 10, search, partner } = req.query;
  if (Number(page) < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = Number((page - 1) * 10);

  const queryMap = {
    attributes: getCollegeDetailAttributes().attributes,
    conditions: [],
    parameters: [],
    joinTbl: [
      `LEFT JOIN ${C_CONTACT} ON ${C_CONTACT}.e_id = ${C_INSTITUTE}.e_id`,
     // `LEFT JOIN ${C_COURSE} ON ${C_COURSE}.e_id = ${C_INSTITUTE}.e_id`
      // `LEFT JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${C_CONTACT}.state OR ${STATE_TBL}.state = ${C_CONTACT}.state)`,
      // `LEFT JOIN ${CITY_TBL} ON (${CITY_TBL}.ctid = ${C_CONTACT}.city OR ${CITY_TBL}.cname = ${C_CONTACT}.city)`
    ],
    additional: [
      // `GROUP BY ${C_INSTITUTE}.e_id`,
      `ORDER BY ${C_INSTITUTE}.insert_date DESC`,
      `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
    distinctCount: `${C_INSTITUTE}.e_id`,
  };

 
 

    if (search) {
      queryMap.conditions.push(`${C_INSTITUTE}.institute_name LIKE ?`);
      queryMap.parameters.push(`%${search}%`);
    }
  
    if (partner) {
      queryMap.conditions.push(`${C_INSTITUTE}.is_partner = ?`);
      queryMap.parameters.push(partner);
    }

   

  

  

  // if (search) {
  //   queryMap.conditions.push(`name LIKE ? OR email LIKE ? OR mobile LIKE ?`);
  //   queryMap.parameters.push(`%${search}%`, `%${search}%`, `%${search}%`);
  // }

  

  const { result, total } = await getCollegePaginationService(queryMap);

  return res.status(200).json({
    status: true,
    data: result,
    records: total,
  });
});





const getCollegeforAdminSearch = tryCatch(async (req, res) => {
  

  const { url, category,course,specialization,search } = req.query;
  const { limit = 0, offset = req.query.limit?req.query.limit:20 } = req.query;


   
  
  // Get colleges list based on URL category
  // Join college details, course details, location details, college content
  const queryMapCollege = {
    attributes: [
      `${C_INSTITUTE}.e_id`,
      `${C_INSTITUTE}.institute_name`,
      `${C_INSTITUTE}.establish`,
      `${C_INSTITUTE}.institute_logo as collegeicon`,
      `${C_INSTITUTE}.institute_mainimg`,
      `${C_INSTITUTE}.is_partner`,
      `${C_INSTITUTE}.institute_url`,
      `${C_INSTITUTE}.priority`,
      `${C_INSTITUTE}.active`,      
      `${C_CONTACT}.state`,
      `${C_CONTACT}.city`,
    ],
    conditions: [
      `${C_INSTITUTE}.active = 'Y' and ${C_INSTITUTE}.is_partner = '1' `,
      // `(${C_COURSE}.course_category LIKE ? AND( ${C_COURSE}.course_name LIKE ? OR ${C_COURSE}.specialization LIKE ? ))`,
    ],
    // parameters: [
    //   ...[
    //     //`%${url}%`,
    //     `%${category}%`,
    //     `%${course}%`,
    //     `%${specialization}%`,
    //   ],
    // ],
    additional: [
      `GROUP BY ${C_INSTITUTE}.e_id`,
      `ORDER BY ${C_INSTITUTE}.is_partner DESC, ${C_INSTITUTE}.priority ASC`,
      `LIMIT 0, ${Number(offset)}`,
    ],
    joinTbl: [
      `INNER JOIN ${C_COURSE} ON ${C_INSTITUTE}.e_id = ${C_COURSE}.e_id`,
      `INNER JOIN ${C_CONTACT} ON ${C_CONTACT}.e_id = ${C_COURSE}.e_id`,
    ],
  };

  


  if(search){
    queryMapCollege.conditions.push(`(${C_COURSE}.course_name LIKE '%${search}%' OR ${C_COURSE}.specialization LIKE '%${search}%')`);
    
  }
 


  
  const { result, total } = await getCollegePaginationService(queryMapCollege);



  

  let collegesResultWithTopCourse=[]

if(search){
   collegesResultWithTopCourse = await setCollegesWithTopCourse(
    result,
    search
  );
}
else
{
  collegesResultWithTopCourse=result
}



  
const sendData = {};
sendData.colleges = collegesResultWithTopCourse;

   
 
 
  
  
  // return res.status(200).json({
  //   status: "success",
  //   data: sendData,
  //   records: 100,
  // });

  return res.status(200).json({
    status: true,
    data: sendData.colleges,
    // records: total,
    records: 100,
  });
});


// @desc post College Details
// @api POST /api/v1/college-details
// @access Private ADMIN
const post_collegeDetails = tryCatch(async (req, res) => {
  const { role, adminId } = req;

  const requiredFields = getCollegeDetailAttributes().mandatoryFields;
  if (!areAllKeysPresent(req.body, requiredFields))
    throw new Error("Please fill all required fields");

  req.body.institute_url &&
    (await postUrlExist(C_INSTITUTE, "institute_url", req.body.institute_url));

  const queryMap = {
    attributes: [
      ...collegeCreateFields,
      "added_by",
      "updated_by",
      "insert_date",
      "priority"
    ],
    parameters: [
      ...collegeCreateFields.map((field) => req.body[field]),
      // adminId,
      // role,
      "admin",
      "admin",
      new Date(),
      (req.body.priority || 20)
    ],
  };


  

  const result = await addNewCollegeService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Failed to insert new college");
  }

  result && insertCollegeDetailsEntry(result.insertId, role, adminId);

  

  return res.status(200).json({
    success: true,
    message: "New College added successfully",
    e_id: result.insertId
  });
});

// @desc   Update college details
// @api  PUT /api/v1/admin/college-details/:e_id
// @access  Private ADMIN
const updateCollegeDetailsById = tryCatch(async (req, res) => {


  

  const { e_id } = req.params;
  const {  update } = req.body;
  if (!e_id || !update) throw new Error(`college ID and Update are required`);

  update.institute_url &&
    (await urlExist(
      C_INSTITUTE,
      "e_id",
      "institute_url",
      update.institute_url,
      e_id
    ));

  const { column, value }= updateColumn(update);

  const queryMap = {
    update : [column, "update_date = NOW()"].join(", "),
    conditions : [`${C_INSTITUTE}.e_id = ?`],
    parameters : [...value, e_id],
  };

  const result = await updateCollegeService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Error while updating college");
  }

  return res.status(200).json({
    success: true,
    message: "College Updated!",
  });

});

// @desc   Delete college details
// @api  DELETE /api/v1/admin/college-details/:e_id
// @access  Private ADMIN
const deleteCollegeDetailsById = tryCatch(async (req, res) => {

  const { e_id } = req.params;
  if (!e_id) throw new Error("Please provide e_id");

  const queryMap = {
    attributes: ["e_id"],
    conditions: ["e_id = ?"],
    parameters: [e_id],
  };

  const result = await deleteCollegeService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Failed to delete college");
  };

  deleteCollegeDetailsEntryFromAdditionalDetails(e_id);
  deleteCollegeDetailsEntyFromCollegeMedia(e_id);
  deleteCollegeDetailsFromContact(e_id);
  deleteCollegeDetailsFromCourse(e_id);

  return res.status(200).json({
    success: true,
    message: "College deleted successfully",
  });

});

module.exports = {
  get_collegeDetails,
  getCollegeforAdminSearch,
  post_collegeDetails,
  deleteCollegeDetailsById,
  updateCollegeDetailsById,
  getCollegeDetailsById,
};

const insertCollegeDetailsEntry = async (e_id, role, id) => {
  try {
    const queryMap = {
      attributes: [`e_id`, `added_by`, `updated_by`],
      parameters: [e_id, "admin", "admin"],
    };
    const [additionalResult] = [
      await addNewCollegeAdditionalDetailsService(queryMap),
    ];

    
    
    if (additionalResult instanceof Error) {
      deleteCollegeService({ conditions: ["e_id = ?"], parameters: [e_id] })
      throw new Error(
        "Error occurred while inserting additional college details"
      );
    }

    const [contactResult] = [
      await addNewCollegecontactDetailsService(queryMap),
    ];

    const [imageResult] = [
      await addNewCollegeImageService(queryMap),
    ];
    

  


  } catch (error) {
    throw new Error(
      "Error occurred while inserting additional college details" + error
    );
  }
};



const deleteCollegeDetailsFromCourse = async (e_id) => {
  try {
    await dbQuery(`DELETE FROM ${C_COURSE} WHERE e_id = ?`, e_id);
  } catch (error) {
    throw new Error("Error occurred" + error);
  }
};

const deleteCollegeDetailsFromContact = async (e_id) => {
  try {
    await dbQuery(`DELETE FROM ${C_CONTACT} WHERE e_id = ?`, e_id);
  } catch (error) {
    throw new Error("Error occurred" + error);
  }
};

const deleteCollegeDetailsEntyFromCollegeMedia = async (e_id) => {
  try {
    await dbQuery(`DELETE FROM ${C_MEDIA} WHERE e_id = ?`, e_id);
  } catch (error) {
    throw new Error("Error occurred" + error);
  }
};

const deleteCollegeDetailsEntryFromAdditionalDetails = async (e_id) => {
  try {
    await dbQuery(`DELETE FROM ${C_ADDITIONAL} WHERE e_id = ?`, e_id);
  } catch (error) {
    throw new Error("Error occurred" + error);
  }
};

const getCollegeDetailAttributes = () => {
  return {
    attributes: [
      `${C_INSTITUTE}.e_id`,
      `${C_INSTITUTE}.institute_name`,
      `${C_INSTITUTE}.show_on_home`,
      `${C_INSTITUTE}.institute_url`,
      `${C_INSTITUTE}.institute_short_name`,
      `${C_INSTITUTE}.institute_logo`,
      `${C_INSTITUTE}.institute_mainimg`,
      `${C_INSTITUTE}.added_by`,
      `${C_INSTITUTE}.updated_by`,
      `${C_INSTITUTE}.insert_date`,
      `${C_INSTITUTE}.update_date`,
      `${C_INSTITUTE}.is_partner`,
      `${C_INSTITUTE}.active`,
      `${C_CONTACT}.contact_person`,
      `${C_CONTACT}.phone_number`,
      `${C_CONTACT}.state AS state`,
      `${C_CONTACT}.city AS city`,
      // `${STATE_TBL}.state AS state`,
      // `${CITY_TBL}.cname AS city`,
    ],
    mandatoryFields: ["institute_url", "institute_name"],
  };
};



const setCollegesWithTopCourse = async (colleges, search) => {
  const collegesWithTopCourse = [];
  for (let i = 0; i < colleges.length; i++) {
    const college = colleges[i];
    const { e_id } = college;
    const queryMapCollegeCourse = {
      attributes: [
        `${C_COURSE}.c_id`,
        `${C_COURSE}.e_id`,
        `${C_COURSE}.course_name`,
        `${C_COURSE}.course_duration`,
        `${C_COURSE}.course_duration_type`,
        `${C_COURSE}.course_fee`,
        `${C_COURSE}.specialization`,
      ],
      conditions: [
        `${C_COURSE}.e_id = ?`,
        `(${C_COURSE}.course_name LIKE ? OR ${C_COURSE}.specialization LIKE ? )`,
      ],
      parameters: [
        e_id,
        ...[
          `%${search}%`,
          `%${search}%`
        ],
      ],
      additional: [`LIMIT 5`],
    };
    const courseResult = await getCollegesCourseService(queryMapCollegeCourse);
    collegesWithTopCourse.push({
      ...college,
      courses: courseResult,
    });
  }
  return collegesWithTopCourse;
};