const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { postUrlExist, urlExist } = require("../../../../utils/url_exist");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { C_CONTENT } = require("../../../../models/tables")

const table = C_CONTENT;

// @desc  Get all college content
// @route GET /api/v1/admin/college-content
// @access  Private
const get_collegeContent = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let qry = "";
  const { search = "", page, limit = 50 } = req.query;
  if (!page || page < 1) throw new Error("Invalid page number");
  const offset = (page - 1) * limit;
  if (search) qry += `WHERE on_url LIKE '%${search}%'`;
  sql = `SELECT * FROM ${table} ${qry} LIMIT ${limit} OFFSET ${offset}`;
  result = await dbQuery(sql);
  if (!result.length) errorMsgEmpty("No data found", res);
  const total = await dbQuery(`SELECT COUNT(*) AS records FROM ${table} ${qry}`);
  const {records} = total[0];
  res.status(200).json({
    success: true,
    data: result,
    records
  });
});

// @desc Add new college content
// @route POST /api/v1/admin/college-content
// @access  Private ADMIN
const post_collegeContent = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const adminRole = req.role;
  const { brief_desc, full_desc, on_url, is_active} =
    req.body;
  if (!brief_desc || !on_url || !is_active)
    throw new Error("Some data missing");
  await postUrlExist(table, "on_url", on_url);
  sql = `INSERT INTO ${table} (brief_desc,full_desc,on_url,is_active,date,create_by) VALUES (?, ?, ?, ?, NOW(), ?)`;
  result = await dbQuery(sql, [
    brief_desc,
    full_desc,
    on_url,
    is_active,
    // date
    adminRole,
  ]);
  res.status(200).json({
    success: true,
    message: "Content added successfully",
  });
});

// @desc Update college content
// @route PUT /api/v1/admin/college-content
// @access  Private ADMIN
const update_collegeContent = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id, update } = req.body;
  if (!id || !update) throw new Error("Invalid data, id or update not found");
  await urlExist(table, "id", "on_url", update.on_url, id);
  const { column, value } = updateColumn(update);
  sql = `UPDATE ${table} SET ${column} WHERE id = ?`;
  result = await dbQuery(sql, [...value, id]);
  res.status(200).json({
    success: true,
    message: "Content updated successfully",
  });
});

// @desc Delete college content
// @route DELETE /api/v1/admin/college-content
// @access  Private ADMIN
const del_collegeContent = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id } = req.body;
  if (!id) throw new Error("Invalid data, id not found");
  sql = `DELETE FROM ${table} WHERE id = ?`;
  result = await dbQuery(sql, [id]);
  res.status(200).json({
    success: true,
    message: "Content deleted successfully",
  });
});

module.exports = {
  get_collegeContent,
  post_collegeContent,
  update_collegeContent,
  del_collegeContent,
};
