const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { postUrlExist, urlExist } = require("../../../../utils/url_exist");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { SC_SCHOOL_CONTENT } = require("../../../../models/tables");

const table = SC_SCHOOL_CONTENT;

// @desc  Get all school content
// @route GET /api/v1/admin/school-content
// @access  Private
const get_schoolContent = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let qry = "";
  const { search = "", page, limit = 50 } = req.query;
  if (!page || page < 1) throw new Error("Invalid page number");
  const offset = (page - 1) * limit;

  if (search) qry += ` AND school_name LIKE '%${search}%' OR school_url LIKE '%${search}%'`;

  sql = `SELECT * FROM ${table} WHERE 1=1 ${qry} LIMIT ${limit} OFFSET ${offset}`;
  result = await dbQuery(sql);
  console.log(sql)

  if (!result.length) errorMsgEmpty("No data found", res);

  const total = await dbQuery(`SELECT COUNT(*) AS records FROM ${table} WHERE 1=1 ${qry}`);
  const { records } = total[0];
  res.status(200).json({
    success: true,
    data: result,
    records,
  });
});

// @desc Add new school content
// @route POST /api/v1/admin/school-content
// @access  Private ADMIN   
const post_schoolContent = tryCatch(async (req, res) => {
    let [sql, result] = [null, null];
    const {
        school_name,
        school_url,
        content,
        priority = null,
        is_active,
    } = req.body; 
    if (!school_name || !school_url || !content || !is_active) throw new Error("Invalid data");
    await postUrlExist(table,"school_url",school_url);
    sql = `INSERT INTO ${table} (school_name,school_url,content,priority,is_active,sc_date) VALUES (?, ?, ?, ?, ?, NOW())`;   
    result = await dbQuery(sql, [school_name, school_url, content, priority, is_active]);
    if (!result.affectedRows) throw new Error("Failed to add content");
    res.status(200).json({
        success: true,
        message:`Content added successfully`,
    });
});

// @desc Update school content
// @route PUT /api/v1/admin/school-content
// @access  Private ADMIN
const update_schoolContent = tryCatch(async (req, res) => {
    let [sql, result] = [null, null];
    const {nr_id,update} = req.body;
    if (!nr_id || !update) throw new Error("Invalid data, id or update not found");
    await urlExist(table,"nr_id","school_url",update?.school_url,nr_id);
    const { column, value } = updateColumn(update);
    sql = `UPDATE ${table} SET ${column}, sc_update_date = NOW() WHERE nr_id = ?`;
    result = await dbQuery(sql,[...value, nr_id]);
    if (!result.affectedRows) throw new Error("Failed to update content");
    res.status(200).json({
        success: true,
        message:`Content updated successfully`,
    });
});

// @desc Delete school content
// @route DELETE /api/v1/admin/school-content
// @access  Private ADMIN
const del_schoolContent = tryCatch(async (req, res) => {
    let [sql, result] = [null, null];
    const {nr_id} = req.body;
    if (!nr_id) throw new Error("Invalid data, id not found");
    sql = `DELETE FROM ${table} WHERE nr_id = ?`;
    result = await dbQuery(sql,[nr_id]);
    if(!result.affectedRows) throw new Error("Failed to delete content");
    res.status(200).json({
        success: true,
        message:`Content deleted successfully`,
    });
});

module.exports = {
    get_schoolContent,
    post_schoolContent,
    update_schoolContent,
    del_schoolContent,
}