const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { postUrlExist, urlExist } = require("../../../../utils/url_exist");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { TBL_ACCORDION_CONTENT } = require("../../../../models/tables");
var async = require("async");

const table = TBL_ACCORDION_CONTENT;

// @desc Get accordion Content
// @route GET /api/v1/accordion-content
// @access Private
const get_accordionContent = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let qry = "";
  let { page, limit = 50, search, type, id } = req.query;
  if (!page || page < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = (page - 1) * limit;

  if (search)
    // qry += ` AND question LIKE '${search}%' OR url LIKE '%${search}%'`;

  qry += ` AND url LIKE '%${search}%'`;
  if (type) qry += ` AND org_type = '${type}'`;
  if (id) qry += ` AND org_id = '${id}'`;


  sql = `SELECT * FROM ${table} WHERE 1=1 and url!='' ${qry}  order by id desc, url asc  LIMIT ${limit} OFFSET ${offset}`;
  // sql= `SELECT * FROM tbl_accordion_content WHERE 1 limit 0,500`;
  result = await dbQuery(sql);
   

  const total = await dbQuery(
    `SELECT COUNT(*) as records FROM ${table} WHERE 1=1 and url!='' ${qry}`
  );
  const { records } = total[0];
  if (result.length === 0) errorMsgEmpty("No data found", res);
  return res.status(200).json({
    success: true,
    data: result,
    records,
  });
});

// @desc post accordion Content
// @api POST /api/v1/accordion-content
// @access Private
const post_accordionContent = tryCatch(async (req, res) => {
    
  const {
    org_type = null,
    org_id = null,
    page_url = null,
    question,
    answer,
    active,
    user_name = null,
    ip = null,
  } = req.body;

   

  async.forEachOf(req.body.data[0].questions[0], function (callback, index, err) {
    try {

       
      sql = `INSERT INTO ${table} (org_type, org_id, url, question, answer, active, user_name, ip, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
      result = dbQuery(sql, [
          org_type,
          org_id,
          req.body.data[0].url,
          req.body.data[0].questions[0][index].question,
          req.body.data[0].questions[0][index].answer,
          req.body.data[0].active=='Y'?req.body.data[0].active:'N',
          user_name,
          ip,
        ]);

    
  return res.status(200).json({
    success: true,
    message: "Accordion content added successfully",
  });
        
    } catch (e) {
      //return callback(err);
    }
  });

  // let [sql, result] = [null, null];
  // const {
  //   org_type = null,
  //   org_id = null,
  //   page_url = null,
  //   question,
  //   answer,
  //   active,
  //   user_name = null,
  //   ip = null,
  // } = req.body;
  // if (!question || !answer || !active)
  //   throw new Error("Some fields are required");
  // sql = `INSERT INTO ${table} (org_type, org_id, url, question, answer, active, user_name, ip, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
  // result = await dbQuery(sql, [
  //   org_type,
  //   org_id,
  //   page_url,
  //   question,
  //   answer,
  //   active,
  //   user_name,
  //   ip,
  //   // date
  // ]);
  // if (!result.affectedRows) throw new Error("Accordion content not added");
  // return res.status(200).json({
  //   success: true,
  //   message: "Accordion content added successfully",
  // });
});



const update_accordion_Content = tryCatch(async (req, res) => {

const {
  org_type = null,
  org_id = null,
  page_url = null,
  question,
  answer,
  active,
  user_name = null,
  ip = null,
} = req.body;

async.forEachOf(req.body.data[0].questions[0], function (callback, index, err) {
  try {

     
    sql = `UPDATE ${table} SET url=?, question=?, answer=?, active=?  WHERE id = ?`;
    result = dbQuery(sql, [
        req.body.data[0].url,
        req.body.data[0].questions[0][index].question,
        req.body.data[0].questions[0][index].answer,
        req.body.data[0].active=='Y'?req.body.data[0].active:'N',
        req.body.data[0].questions[0][index].eid
      ]);

    
  
return res.status(200).json({
  success: true,
  message: "Accordion content updated successfully",
});
      
  } catch (e) {
    //return callback(err);
  }
});

 
});



// @desc Delete accordion Content
// @route DELETE /api/v1/accordion-content
// @access Private
const del_accordionContent = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];

  // const { id } = req.query.id;
  const id = req.query.id;
  if (!id) throw new Error("Id is required");
  sql = `DELETE FROM ${table} WHERE id = ? LIMIT 1`;
  result = await dbQuery(sql, [id]);
  if (!result.affectedRows) throw new Error("Accordion content not deleted");
  return res.status(200).json({
    success: true,
    message: "Accordion content deleted successfully",
  });
});

module.exports = {
  get_accordionContent,
  post_accordionContent,
  update_accordion_Content,
  del_accordionContent,
  
};
