const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { EMAIL_GROUP_ACTION } = require("../../../../models/tables");

const table = EMAIL_GROUP_ACTION;

// @desc    Get all email action
// @api   GET /api/v1/admin/email-action
// @access  Private ADMIN
const getEmailAction = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  sql = `SELECT * FROM ${table}`;
  result = await dbQuery(sql);
  if (result.length === 0) errorMsgEmpty("Email Action is empty", res);
  return res.status(200).json({
    success: true,
    data: result,
  });
});

// @desc    create email action
// @api   POST /api/v1/admin/email-action
// @access  Private ADMIN
const createEmailAction = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { gid, group_action, active } = req.body;
  if (!gid || !group_action || !active)
    throw new Error("Please fill all required fields");
  sql = `INSERT INTO ${table} (gid, group_action, active) VALUES (?, ?, ?)`;
  result = await dbQuery(sql, [gid, group_action, active]);
  if (!result.affectedRows) throw new Error("Email Action not created");
  return res.status(200).json({
    success: true,
    message: "Email Action created successfully",
  });
});

// @desc    update email action
// @api   PUT /api/v1/admin/email-action
// @access  Private ADMIN
const updateEmailAction = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id, update } = req.body;
  if (!id || !update) throw new Error("Please fill all required fields");
  const { column, value } = updateColumn(update);
  sql = `UPDATE ${table} SET ${column} WHERE id = ?`;
  result = await dbQuery(sql, [...value, id]);
  if (!result.affectedRows) throw new Error("Email Action not found");
  return res.status(200).json({
    success: true,
    message: "Email Action updated successfully",
  });
});

// @desc    delete email action
// @api   DELETE /api/v1/admin/email-action
// @access  Private ADMIN
const deleteEmailAction = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id } = req.body;
  if (!id) throw new Error("Please fill all required fields");
  sql = `DELETE FROM ${table} WHERE id = ?`;
  result = await dbQuery(sql, [id]);
  if (!result.affectedRows) throw new Error("Email Action not found");
  return res.status(200).json({
    success: true,
    message: "Email Action deleted successfully",
  });
});

module.exports = {
  getEmailAction,
  createEmailAction,
  updateEmailAction,
  deleteEmailAction,
};
