const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { EMAIL_GROUP } = require("../../../../models/tables");

const table = EMAIL_GROUP;

// @desc    Get all email group
// @api   GET /api/v1/admin/email-group
// @access  Private ADMIN
const getEmailGroup = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  sql = `SELECT * FROM ${table}`;
  result = await dbQuery(sql);
  if (result.length === 0) errorMsgEmpty("Email Group", res);
  return res.status(200).json({
    success: true,
    data: result,
  });
});

//@desc Create new email group
//@api POST /api/v1/admin/email-group
//@access Private ADMIN
const createEmailGroup = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { group_name, active } = req.body;
  if (!group_name || !active) throw new Error("Enter all details");
  sql = `INSERT INTO ${table} (group_name, active) VALUES (?, ?)`;
  result = await dbQuery(sql, [group_name, active]);
  return res.status(200).json({
    success: true,
    message: "Email group created successfully",
  });
});

//@desc Update email group
//@api PUT /api/v1/admin/email-group
//@access Private ADMIN
const updateEmailGroup = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id, update } = req.body;
  if (!id || !update) throw new Error("Some details are missing");
  const { column, value } = updateColumn(update);
  sql = `UPDATE ${table} SET ${column} WHERE id = ?`;
  result = await dbQuery(sql, [...value, id]);
  return res.status(200).json({
    success: true,
    message: "Email group updated successfully",
  });
});

//@desc Delete email group
//@api DELETE /api/v1/admin/email-group
//@access Private ADMIN
const deleteEmailGroup = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id } = req.body;
  if (!id) throw new Error("Enter all details");
  sql = `DELETE FROM ${table} WHERE id = ?`;
  result = await dbQuery(sql, [id]);
  return res.status(200).json({
    success: true,
    message: "Email group deleted successfully",
  });
});

module.exports = {
  getEmailGroup,
  createEmailGroup,
  updateEmailGroup,
  deleteEmailGroup,
};
