const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { EMAIL_TEMPLATE } = require("../../../../models/tables");

const table = EMAIL_TEMPLATE;

// @desc    Get all email template
// @api   GET /api/v1/admin/email-template
// @access  Private ADMIN
const getEmailTemplate = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { limit = 50, search, page = 1 } = req.query;
  const offset = (page - 1) * limit;
  let qry = "";
  if (search) qry = `WHERE title LIKE '%${search}%'`;
  sql = `SELECT id, title, type, subject, template_for, contents, sort_order, is_active, created_ts FROM ${table} ${qry} LIMIT ${limit} OFFSET ${offset}`;
  result = await dbQuery(sql);
  if (result.length === 0) errorMsgEmpty("Email Template is empty", res);
  const totalRecords = result.length;
  return res.status(200).json({
    success: true,
    data: result,
    records: totalRecords,
  });
});

// @desc    create email template
// @api   POST /api/v1/admin/email-template
// @access  Private ADMIN
const createEmailTemplate = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const {
    is_active,
    et_group,
    et_group_action,
    title,
    subject,
    type,
    template_for,
    contents,
    sort_order = null,
  } = req.body;
  if (
    !is_active ||
    !et_group ||
    !et_group_action ||
    !title ||
    !subject ||
    !type ||
    !template_for ||
    !contents
  )
    throw new Error("Please fill all required fields");
  sql = `INSERT INTO ${table} (is_active, et_group, et_group_action, title, subject, type, template_for, contents, sort_order, created_ts) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
  result = await dbQuery(sql, [
    is_active,
    et_group,
    et_group_action,
    title,
    subject,
    type,
    template_for,
    contents,
    sort_order,
  ]);
  if (!result.affectedRows) throw new Error("Email Template not created");
  return res.status(200).json({
    success: true,
    message: "Email Template created successfully",
  });
});

// @desc    update email template
// @api   PUT /api/v1/admin/email-template
// @access  Private ADMIN
const updateEmailTemplate = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id, update } = req.body;
  if (!id || !update) throw new Error("id or update is empty");
  const { column, value } = updateColumn(update);
  sql = `UPDATE ${table} SET ${column}, updated_ts = NOW() WHERE id = ?`;
  result = await dbQuery(sql, [...value, id]);
  if (!result.affectedRows) throw new Error("Email Template not found");
  return res.status(200).json({
    success: true,
    message: "Email Template updated successfully",
  });
});

// @desc    delete email template
// @api   DELETE /api/v1/admin/email-template
// @access  Private ADMIN
const deleteEmailTemplate = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id } = req.body;
  if (!id) throw new Error("id is empty");
  sql = `DELETE FROM ${table} WHERE id = ?`;
  result = await dbQuery(sql, [id]);
  if (!result.affectedRows) throw new Error("Email Template not found");
  return res.status(200).json({
    success: true,
    message: "Email Template deleted successfully",
  });
});

module.exports = {
  getEmailTemplate,
  createEmailTemplate,
  updateEmailTemplate,
  deleteEmailTemplate,
};
