const tryCatch = require("../../../../utils/tryCatch");
const {
  EMAIL_TEMPLATE,
  SCHOOL_DETAIL,
  C_INSTITUTE,
  CAREER_LIST,
  COURSE,
  SC_USER,
  C_COURSE,
} = require("../../../../models/tables");
const { dbQuery } = require("../../../../config/db.config");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { transporter } = require("./email");

const table = EMAIL_TEMPLATE;
const schoolTbl = SCHOOL_DETAIL;
const collgeTbl = C_INSTITUTE;
const career = CAREER_LIST;
const course = COURSE;
const student = SC_USER;
const intCourse = C_COURSE;

const { EMAIL_FROM } = process.env;


const testemail = tryCatch(async (req, res) => {



  // transporter.verify(function (error, success) {
  //   if (error) {
  //     // return error

  //     return res.status(500).json({
  //       success: error,
  //       message: error,
  //       error: error,
  //     });

      
  //   } else {
  //     // return ("Server is ready to take our messages");

  //     return res.status(500).json({
  //       success: "Server is ready to take our messages shani",
  //       message: "Server is ready to take our messages",
  //       error: "Server is ready to take our messages",
  //     });
  //   }
  // });

  


// // setup e-mail data with unicode symbols
// var mailOptions = {
//     from: "info@allschoolscolleges.com",    // sender address
//     to: 'shani.intactadvt@gmail.com', // list of receivers
//     subject: 'Demo-ppp', // Subject line
//     text: 'Hello world from Node.js',       // plaintext body
//     html: '<b>Hello world from Node.js</b>' // html body
// };

 


//  transporter.sendMail(mailOptions, function (error, info) {
//       if (error) {
//         return res.status(500).json({
//           success: false,
//           message: "Email not sent",
//           error: error,
//         });
//       }
//     });
  
 
})

const sendMailToUser = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { recipients, templateId } = req.body;

  const getAllStudentsId = [];
  const studentDetailsMap = {};

  recipients.forEach((recipient) => {
    getAllStudentsId.push(recipient.id);
    studentDetailsMap[recipient.id] = recipient;
  });

  sql = `SELECT title, subject, contents, attachments FROM ${table} WHERE id = ? LIMIT 1`;
  result = await dbQuery(sql, [templateId]);
  if (result.length === 0)
    return errorMsgEmpty("Email Template does not exist", res);

  const { title, subject, contents, attachments } = result[0];

  // Get all variables that are in the email template contents
  const regex = /\[[^\]]*\]/g;
  const variables = contents.matchAll(regex);

  // Query for each specific variables available in the email template

  const attributes = {};
  const tblJoin = {};

  for (const query of variables) {
    switch (query[0]) {
      case "[COURSE]":
      case "[COLLEGE]":
        attributes[
          "collge_course"
        ] = `${collgeTbl}.institute_name, ${intCourse}.course_name `;
        tblJoin[
          "collge_course_join"
        ] = `LEFT JOIN ${intCourse} ON ${intCourse}.c_id = ${student}.course 
             LEFT JOIN ${collgeTbl} ON ${collgeTbl}.e_id = ${intCourse}.e_id `;
        break;
      case "[CARREER-COLLEGE]":
      case "[CAREER-COURSE]":
      case "[CAREER-NAME]":
        attributes[
          "career"
        ] = `${career}.career_name, ${course}.course_name AS career_course, ${collgeTbl}.institute_name `;
        tblJoin[
          "career_join"
        ] = `LEFT JOIN ${course} ON ${career}.course_id = ${course}.course_id 
             LEFT JOIN ${collgeTbl} ON ${collgeTbl}.institute_url LIKE '%${career}.ex_college_url' `;
        break;
      default:
        break;
    }
  }

  const query = `SELECT us_id AS id, us_fname AS name, course, url, user_type,
                ${attributes["collge_course"] || ""}
                ${attributes["career"] || ""}
                FROM ${student}
                ${tblJoin["collge_course_join"] || ""}
                ${tblJoin["career_join"] || ""}
                WHERE 1=1 AND us_id IN (?)`;

  const studentDetails = await dbQuery(query, [getAllStudentsId.join(",")]);

  // Replace the variables with the actual values
  studentDetails.forEach((student) => {
    const { id, user_type } = student;
    let studentContent = contents;
    for (const query of variables) {
      switch (query[0]) {
        case "[NAME]":
          studentContent = studentContent.replace(query[0], student.name);
          break;
        case "[COURSE]":
          studentContent = studentContent.replace(query[0], student.course);
          break;
        case "[COLLEGE]":
          studentContent = studentContent.replace(query[0], student.institute_name);
          break;
        case "[CAREER-COLLEGE]":
          studentContent = studentContent.replace(query[0], student.institute_name);
          break;
        case "[CAREER-COURSE]":
          studentContent = studentContent.replace(query[0], student.career_course);
          break;
        case "[CAREER-NAME]":
          studentContent = studentContent.replace(query[0], student.career);
          break;
        default:
          break;
      }
    }

    const mailOptions = {
      from: EMAIL_FROM, // replace with your email address
      to: studentDetailsMap[id].email, // replace with the recipient email address
      subject: subject,
      html: studentContent,
    };

    // transporter.sendMail(mailOptions, function (error, info) {
    //   if (error) {
    //     return res.status(500).json({
    //       success: false,
    //       message: "Email not sent",
    //       error: error,
    //     });
    //   }
    // });
  });

  return res.status(200).send();
});

// @desc    Send customized email to users
// @route   POST /api/v1/admin/send-custom-email
// @access  Private ADMIN
const sendCustomizedMailToUsers = tryCatch(async (req, res) => {
  const { recipients, subject, contents } = req.body;
  if (!recipients || !subject || !contents)
    throw new Error("Please fill all required fields");

  if (!Array.isArray(recipients)) recipients = [recipients]; // if recipients is not an array, make it an array

  recipients.forEach((recipient) => {
    const mailOptions = {
      from: EMAIL_FROM, // replace with your email address
      to: recipient, // replace with the recipient email address
      subject: subject,
      html: contents,
    };

    transporter.sendMail(mailOptions, function (error, info) {
      if (error) {
        console.log(error);
        return res.status(500).json({
          success: false,
          message: "Email not sent",
          error: error,
        });
      }
    });
  });

  return res.status(200).json({
    success: true,
    message: "Email sent successfully",
  });
});

module.exports = {
  sendMailToUser,
  sendCustomizedMailToUsers,
  testemail,
};
