"use strict";
const nodemailer = require("nodemailer");
const aws = require("aws-sdk");
const sesTransport = require("nodemailer-ses-transport");
const tryCatch = require("../../../../utils/tryCatch");
const { EMAIL_TEMPLATE } = require("../../../../models/tables");
const { dbQuery } = require("../../../../config/db.config");
const { errorMsgEmpty } = require("../../../../utils/errors_message");

const { EMAIL_FROM, AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY, AWS_REGION } = process.env;

const table = EMAIL_TEMPLATE;

let [sql, result] = [null, null];

const mailSentCallback = (error, info) => {
  if (error) {
    console.log(error);
    return res.status(500).json({
      success: false,
      message: "Email not sent",
      error: error,
    });
  }
}

const transporter = nodemailer.createTransport(
  sesTransport({
    ses: new aws.SES({
      accessKeyId: AWS_ACCESS_KEY_ID,
      secretAccessKey: AWS_SECRET_ACCESS_KEY,
      AWS_REGION: AWS_REGION, // replace with your AWS SES AWS_REGION
    }),
  })
);

const sendMailToUser = tryCatch(async (req, res) => {
  const { recipients, templateID } = req.body;
  if (!recipients || !templateID)
    throw new Error("Please fill all required fields");

  // Get email template from DB
  sql = `SELECT title,subject,contents FROM ${table} WHERE id = ?`;
  result = await dbQuery(sql, [templateID]);
  if (result.length === 0) errorMsgEmpty("No template found with ID", res);

  const { title, subject, contents } = result[0];

  if (!Array.isArray(recipients)) recipients = [recipients]; // if recipients is not an array, make it an array

  recipients.forEach((recipient) => {
    const mailOptions = {
      from: EMAIL_FROM, // replace with your email address
      to: recipient, // replace with the recipient email address
      subject: subject,
      html: contents,
    };

    transporter.sendMail(mailOptions, mailSentCallback);
  });

  return res.status(200).json({
    success: true,
    message: "Email sent successfully",
  });
});

const sendCustomizedMailToUsers = tryCatch(async (req, res) => {

  const { recipients, subject, contents } = req.body;
  if (!recipients || !subject || !contents)
    throw new Error("Please fill all required fields");

  if (!Array.isArray(recipients)) recipients = [recipients]; // if recipients is not an array, make it an array

  recipients.forEach((recipient) => {
    const mailOptions = {
      from: EMAIL_FROM, // replace with your email address
      to: recipient, // replace with the recipient email address
      subject: subject,
      html: contents,
    };

    transporter.sendMail(mailOptions, mailSentCallback);
  });

  return res.status(200).json({
    success: true,
    message: "Email sent successfully",
  });
});

module.exports = {
  sendMailToUser,
  sendCustomizedMailToUsers,
  transporter,
  mailSentCallback
};
