const tryCatch = require("../../../../utils/tryCatch");
const { EMAIL_TEMPLATE } = require("../../../../models/tables");
const { dbQuery } = require("../../../../config/db.config");
const { errorMsgEmpty } = require("../../../../utils/errors_message");

const table = EMAIL_TEMPLATE;

// @desc Send Template for required Section
// @route POST /api/v1/admin/template
// @access Private ADMIN
const sendTemplateSection = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { template_for } = req.query;

  const attributes = [`${table}.id`, `${table}.title`, `${table}.type`];
  const insertBody = [];
  sql = `SELECT ${attributes.join(
    ","
  )} FROM ${table} WHERE is_active=1 and template_for LIKE ? OR template_for LIKE ? OR template_for LIKE ?`;

  switch (template_for) {
    case "school-enquiry":
      insertBody.push(
        ...[
          "%manage_school_admission_help_query%",
          "%manage_school%",
          "%admission_query_from_partner_school%",
        ]
      );
      break;
    case "career-enquiry":
      insertBody.push(...["%career_enquiry%", "%footer_career_enq%", "%career%"]);
      break;
      case "college-enquiry":
        insertBody.push(...["%interest_query_from_partner_college%", "%manage_college%","%study-abroad%"]);
        break;
    default:
      throw new Error("Invalid section");
  }

  result = await dbQuery(sql, insertBody);
  if (result.length === 0) errorMsgEmpty("No data found", res);

  return res.status(200).json({ success: true, data: result });
});

module.exports = {
  sendTemplateSection,
};
