"use strict";
const tryCatch = require("../../../../utils/tryCatch");
const axios = require("axios");
const { SEND_OTP } = require("./sms_template_contants");

const { SMS_USERNAME, SMS_PSWD, SENDER_ID } = process.env;

var resOtp = "";

const sendSMSOtp = tryCatch(async (req, res) => {
  const otp = Math.floor(1000 + Math.random() * 9000);
  const { phone, name } = req.body;
  if (!phone || !name) throw new Error("Phone number is required");

  const otpTemplate = SEND_OTP.replace("{#name#}", name).replace("{#otp#}", otp);

  const smsURL = `http://sms.mishtel.net/api/mt/SendSMS?user=${SMS_USERNAME}&password=${SMS_PSWD}&senderid=${SENDER_ID}&channel=Trans&DCS=0&flashsms=0&number=${phone}&text=${otpTemplate}(INTASC)&route=1`;

  const smsOptions = {
    method: "GET",
    url: smsURL,
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
    },
  };

  axios(smsOptions)
    .then((response) => {
      if(response.data.ErrorCode !== '000') throw response.data.ErrorMessage;
      resOtp = otp;
      return res.status(200).json({
        success: true,
        message: "OTP sent successfully",
      });
    })
    .catch((error) => {
      console.log(error);
      return res.status(500).json({
        success: false,
        message: "OTP not sent",
      });
    });
});

const verifySMSOtp = tryCatch(async (req, res) => {
  const { otp: userOtp } = req.body;
  if (userOtp !== resOtp.toString()) {
    res.statusCode = 400;
    throw new Error("OTP not matched or expired");
  }
  return res.status(200).json({
    success: true,
    message: "OTP Verfiied",
  });
});

module.exports = {
  sendSMSOtp,
  verifySMSOtp,
};
