const { dbQuery } = require("../../../../../config/db.config");
const tryCatch = require("../../../../../utils/tryCatch");
const { errorMsgEmpty } = require("../../../../../utils/errors_message");
const { LANDING_PAGE } = require("../../../../../models/tables");

const table = LANDING_PAGE;

// @desc Get enquiry from landing page
// @route GET /api/v1/admin/enquiry/partner-enquiry
// @access Private

const get_partnerEnquiry = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let qry = "";
  let { page, limit = 50, search } = req.query;
  if (!page || page < 1)
    throw new Error(`Page number is required and should be greater than 0`);
  const offset = (page - 1) * limit;
  if (search) qry += `WHERE name LIKE '${search}%' OR email LIKE '${search}%' OR phone LIKE '${search}%'`;
  sql = `SELECT * FROM ${table} ${qry} order by qry_date desc LIMIT ${limit} OFFSET ${offset}`;
  
  result = await dbQuery(sql);
  if (result.length === 0) errorMsgEmpty("No data found", res);
  const total = await dbQuery(`SELECT COUNT(*) as records FROM ${table} ${qry}`);
  const { records } = total[0];
  return res.status(200).json({ success: true, data: result, records });
});

// Delete enquiry from landing page
// @route DELETE /api/v1/admin/enquiry/partner-enquiry
// @access Private ADMIN
const del_partnerEnquiry = tryCatch(async (req, res) => {

  
  let [sql, result] = [null, null];
  const { id } = req.body;
  if (!id) throw new Error("Id is required");
  sql = `DELETE FROM ${table} WHERE id = ?`;
  result = await dbQuery(sql, [id]);
  if (!result.affectedRows)
    throw new Error("Error! cant delete partner enquiry");
  return res
    .status(200)
    .json({ success: true, message: "Enquiry deleted successfully" });
});

module.exports = {
    get_partnerEnquiry,
    del_partnerEnquiry,
};