const tryCatch = require("../../../../../utils/tryCatch");
const {
  TBL_FOOTER_CAREER_ENQ,
  COURSE,
  CATEGORY,
  STATE_TBL,
  CITY_TBL
} = require("../../../../../models/tables");
const {
  getEnquiryPaginationService, deleteEnquiryService,
} = require("../../../../../services/enquiry.service");

const table = TBL_FOOTER_CAREER_ENQ;

// @desc get all footer enquiry list from career
// @api GET /api/v1/admin/footer-enquiry
// @access Private
const get_footerEnquiry = tryCatch(async (req, res) => {
  const { page = 1, limit = 50, search } = req.query;
  if (Number(page) < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = (page - 1) * limit;

  const queryMap = {
    attributes: [
      `${TBL_FOOTER_CAREER_ENQ}.*`,
      `${COURSE}.course_name AS course`,
      `${CATEGORY}.cat_name AS stream`,
      `${STATE_TBL}.state`,
      `${CITY_TBL}.cname as city`,
    ],
    conditions: [],
    parameters: [],
    additional: [
      `ORDER BY ${TBL_FOOTER_CAREER_ENQ}.date DESC`,
      `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
    joinTbl: [
      `LEFT JOIN ${COURSE} ON (${COURSE}.course_id = ${TBL_FOOTER_CAREER_ENQ}.course OR ${COURSE}.course_name = ${TBL_FOOTER_CAREER_ENQ}.course)`,
      `LEFT JOIN ${CATEGORY} ON (${CATEGORY}.cat_id = ${TBL_FOOTER_CAREER_ENQ}.stream OR ${CATEGORY}.cat_name = ${TBL_FOOTER_CAREER_ENQ}.stream)`,
      `LEFT JOIN ${STATE_TBL} ON ${STATE_TBL}.sid = ${TBL_FOOTER_CAREER_ENQ}.state`,
      `LEFT JOIN ${CITY_TBL} ON ${CITY_TBL}.ctid = ${TBL_FOOTER_CAREER_ENQ}.city`

    ],
    table: TBL_FOOTER_CAREER_ENQ,
  };

  if (search) {
    queryMap.conditions.push(`name LIKE ? OR email LIKE ? OR contact LIKE ?`);
    queryMap.parameters.push(`%${search}%`, `%${search}%`, `%${search}%`);
  }

  const { result, total } = await getEnquiryPaginationService(queryMap);

  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });
});

// @desc Delete footer enquiry list from career
// @api DELETE /api/v1/admin/footer-enquiry
// @access Private
const del_footerEnquiry = tryCatch(async (req, res) => {

  const { id } = req.body;
  if (!id) {
    res.statusCode = 400;
    throw new Error("footer Id not required")
  };

  const queryMap = {
    conditions: [`${TBL_FOOTER_CAREER_ENQ}.id = ?`],
    parameters: [id],
    table: TBL_FOOTER_CAREER_ENQ
  };

  const result = await deleteEnquiryService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while deleting footer enquiry")
  }
  
  return res.status(200).json({
    success: true,
    message: "Footer enquiry deleted successfully"
  })

});

module.exports = {
  get_footerEnquiry,
  del_footerEnquiry,
};
