const tryCatch = require("../../../../../utils/tryCatch");
const { ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY, STATE_TBL } = require("../../../../../models/tables");
const { getEnquiryPaginationService, deleteEnquiryService } = require("../../../../../services/enquiry.service")

// @desc    Get all exam Enquiry
// @route   GET /api/v1/admin/enquiry/exam
// @access  Private
const get_examEnquiry = tryCatch(async (req, res) => {

const { page = 1, limit = 50, search } = req.query;
if(Number(page) < 1) throw new Error("Page number is required and should be greater than 0");
const offset = (page - 1) * limit;

const queryMap = {
  attributes: [`${ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY}.*`, `${STATE_TBL}.state AS inputstate`],
  conditions:[],
  parameters:[],
  joinTbl: [`LEFT JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY}.inputstate OR ${STATE_TBL}.state = ${ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY}.inputstate)`],
  additional:[`ORDER BY ${ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY}.date DESC`, `LIMIT ${Number(limit) || 10} OFFSET ${offset}`],
  table: ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY,
}

if(search){
  queryMap.conditions.push(`${ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY}.inputname LIKE ? OR ${ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY}.inputemail LIKE ? OR ${ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY}.inputemobile LIKE ?`);
  queryMap.parameters.push(`%${search}%`,`%${search}%`,`%${search}%`);
}

const { result, total } = await getEnquiryPaginationService(queryMap);
if(result instanceof Error){
  res.statusCode = 400;
  throw new Error("Error occurred while fetching exam enquiry")
}

return res.status(200).json({
  success: true,
  data: result,
  records: total
})

});

// @desc Delete exam Enquiry
// @route DELETE /api/v1/admin/enquiry/exam
// @access Private
const del_examEnquiry = tryCatch(async (req, res) => {
 
  const { id } = req.body;
  if(!id){
    res.statusCode = 400;
    throw new Error("No Id found");
  }

  const queryMap = {
    table: ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY,
    conditions:[`${ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY}.id = ?`],
    parameters: [id],
  }

  const result  = await deleteEnquiryService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while deleting the enquiry");
  }

  return res.status(200).json({
    success: true,
    message: "Exam enquiry deleted successfully"
  })

});

module.exports = {
  get_examEnquiry,
  del_examEnquiry,
};
