const { dbQuery } = require("../../../../../config/db.config");
const tryCatch = require("../../../../../utils/tryCatch");
const axios = require("axios");
const { errorMsgEmpty } = require("../../../../../utils/errors_message");
const {
  STUDY_INDIA,
  EMAIL_TEMPLATE,
  STUDY_INDIA_THREAD,
  SCHOOL_DETAIL,
} = require("../../../../../models/tables");
const { SCHOOL } = require("../../../../../common/constants");
const { transporter } = require("../../EmailTemplate/email");
const {
  checkSchoolQueryExist,
  checkSchoolExist,
  getSchoolsBasicDetails,
} = require("../../../../../utils/leadAccessCheck");
const {
  getEnquiryPaginationService, getEnquiryService, deleteEnquiryService, updateEnquiryService,
} = require("../../../../../services/enquiry.service");


const { getSinglevalueByid }  = require("../../../../../utils/leadAccessCheck")
const { EMAIL_FROM } = process.env;
const { SMS_USERNAME, SMS_PSWD, SENDER_ID } = process.env;

const table = STUDY_INDIA;
const templateTbl = EMAIL_TEMPLATE;
const messageTbl = STUDY_INDIA_THREAD;

// @desc Get one study india Enquiry Details on id
// @route GET /api/v1/admin/enquiry/studyindia/:s_id
// @access Private ADMIN
const getStudyIndiaEnquiryDetails = tryCatch(async (req, res) => {

  const { s_id } = req.params;

  const queryMap = {
    attributes: [`${STUDY_INDIA}.*`],
    conditions: [`${STUDY_INDIA}.s_id = ?`],
    parameters: [s_id],
    additional: [`LIMIT 1`],
    table: STUDY_INDIA,
  };

  const result = await getEnquiryService(queryMap);
  if(result instanceof Error || !result[0]){
    errorMsgEmpty("No data found", res);
  }

  const enquiryData = result.pop();
  
  const queryMapMessage = {
    attributes: [
      `${messageTbl}.t_id`,
      `${messageTbl}.message`,
      `${messageTbl}.post_date`,
    ],
    conditions: [`${STUDY_INDIA_THREAD}.s_id = ?`],
    parameters: [s_id],
    table: STUDY_INDIA_THREAD,
  }

  const messageResult = await getEnquiryService(queryMapMessage);
  enquiryData.messages = [...messageResult];

  return res.status(200).json({
    success: true,
    data: enquiryData,
  })

});

// @desc Get all study india Enquiry
// @route GET /api/v1/admin/enquiry/studyindia
// @access Private
const get_studyindiaEnquiry = tryCatch(async (req, res) => {
  const { page = 1, limit = 50, search} = req.query;
  if (Number(page) < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = (page - 1) * limit;

console.log(">>>>",req.query)
 
  
  const queryMap = {
    table: STUDY_INDIA,
    attributes: [
      `${table}.s_id`,
      `${table}.name`,
      `${table}.mobile`,
      `${table}.parent_name`,
      `${table}.email`,
      `${table}.school_grade`,
      `${table}.school_type`,
      `${table}.current_location`,
      `${table}.edu_interest`,
      `${table}.city`,
      `${table}.mailsent AS mail_sent`,
      `${table}.currentpageurl AS url`,
      `${table}.post_date`,
      `${table}.npf_response`,
      `${SCHOOL_DETAIL}.school_name`,
       `${table}.budget`,
    ],
    additional: [
      `ORDER BY ${STUDY_INDIA}.s_id DESC`,
      `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
    conditions: [],
    parameters: [],
    joinTbl: [
      `LEFT JOIN ${SCHOOL_DETAIL} ON ${SCHOOL_DETAIL}.sid = ${STUDY_INDIA}.school_id`,
    ],
  };

  if (search) {
    queryMap.conditions.push(`name LIKE ? OR email LIKE ? OR mobile LIKE ?`);
    queryMap.parameters.push(`%${search}%`, `%${search}%`, `%${search}%`);
  }

  if(req.query.date1 && req.query.date2)
  {
    if(req.query.std){
    queryMap.conditions.push(`school_grade LIKE ? `);
    queryMap.parameters.push(`%${req.query.std}%`);
      
    }
    queryMap.conditions.push(`post_date between ? and ?`);
    queryMap.parameters.push(`${req.query.date1}`, `${req.query.date2}`);
    // queryMap.additional.push(`ORDER BY ${STUDY_INDIA}.post_date asc`,`LIMIT ${Number(limit) || 10} OFFSET ${offset}`,)
    
  }


  const { result, total } = await getEnquiryPaginationService(queryMap);
  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });

});

// @desc Update study india Enquiry for Remark
// @route PUT /api/v1/admin/enquiry/studyindia/:s_id
// @access Private
const update_studyindiaEnquiry = tryCatch(async (req, res) => {

  const { s_id } = req.params;

  const { remark, remark_cause } = req.body;
  if(!remark || !remark_cause){
    res.statusCode = 400;
    throw new Error("Error while updating remark, Both Remark and cause is required");
  };

  const queryMap = {
    update: [`remark = ?`, `remark_cause = ?`, `remark_date = NOW()`],
    conditions: [`${STUDY_INDIA}.s_id = ?`],
    parameters: [remark, remark_cause, s_id],
    table: STUDY_INDIA
  };

  const result = await updateEnquiryService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while updating the remark for this enquiry");
  }

  return res.status(200).json({
    success: true,
    message: "Remark added successfully"
  })

});

// @desc Delete study india Enquiry
// @route DELETE /api/v1/admin/enquiry/studyindia/:s_id
// @access Private
const del_studyindiaEnquiry = tryCatch(async (req, res) => {
 
  const { s_id } = req.params;

  const queryMap = {
    table: STUDY_INDIA,
    conditions: [`${STUDY_INDIA}.s_id = ?`],
    parameters: [s_id],
  };

  const result = await deleteEnquiryService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while deleting the Enquiry")
  };

  return res.status(200).json({
    success: true,
    message: "Enquiry deleted successfully"
  })

});

// @desc Send email to one student
// @route POST /api/v1/admin/enquiry/studyindia/mail/:s_id
// @access Private ADMIN
const sendEnquiryMailToStudent = tryCatch(async (req, res) => {
  const { s_id } = req.params;
  const doesSchoolQueryExist = await checkSchoolQueryExist(s_id);
  if (!doesSchoolQueryExist) throw new Error("Invalid s_id");

  const { email, name, mobile, message } = req.body;
  if (!email || !name || !message) throw new Error("Please enter all details");
  const mailOptions = {
    from: EMAIL_FROM,
    to: email,
    subject: "Admission Help Query Details on allschoolcollege.com",
    html: message,
  };
  transporter.sendMail(mailOptions, (error, info) => {
    if (error) {
      return res.status(500).json({
        success: false,
        message: "Error in sending mail",
        error: error.message,
      });
    }
    const sql = `UPDATE ${table} SET mailsent = ?  WHERE s_id = ?`;
    const result = dbQuery(sql, [1, s_id]);
    if (!result) throw new Error("Error in updating mailsent status, check Id");

    const messageAddSql = `INSERT INTO ${messageTbl} (s_id, name, message, post_date) VALUES (?, ?, ?, NOW())`;
    const messageAddResult = dbQuery(messageAddSql, [s_id, name, message]);

    if (!messageAddResult)
      throw new Error("Error in adding message, but email is sent");

    return res
      .status(200)
      .json({ success: true, message: "Mail sent successfully" });
  });
});

// @desc Send bulk email to all student
// @route POST /api/v1/admin/enquiry/studyindia/mails
// @access Private ADMIN
const sendBulkEnquiryMailToStudents = tryCatch(async (req, res) => {

  //  console.log("MAILK>>",req.body)
  const { recipients, templateId, school_id } = req.body;
  if (!recipients || !templateId)
    throw new Error("Some required fields are missing");
  const recipientsFields = [];
  recipients.forEach(async (recipient) => {
    if (!recipient.email || !recipient.name)
      throw new Error("Some required fields are missing");
    // let course_fee = await getSinglevalueByid("course_fee","engineering_institute_course","c_id",recipient.courseid);
    // let application_fee = await getSinglevalueByid("application_fee","engineering_institute","institute_url",recipient.college);

      
    // const results = await dbQuery(`SELECT course_fee, application_fee FROM engineering_institute_course
    // JOIN engineering_institute on engineering_institute.e_id=engineering_institute_course.e_id
    // WHERE 1=1 AND c_id = ? LIMIT 1`, [recipient.courseid]);

      

      

    // recipientsFields.push({
    //   email: recipient.email,
    //   name: recipient.name,
    //   mobile: recipient.mobile,
    //   college: recipient.college,
    //   course: recipient.course ,
    //   specialization: recipient.specialization,  
    //   course_fee:results[0].course_fee,
    //   application_fee:results[0].application_fee 
    // });


    
  
    

    recipientsFields.push({
      email: recipient.email,
      name: recipient.name,
      mobile: recipient.mobile,
      college: recipient.college,
      course: recipient.course,
      courseid:recipient.courseid,
      specialization: recipient.specialization,  
      us_id:recipient.us_id
    });


  
  });

  // Fetch Template details
  const attributes = [
    `${templateTbl}.id`,
    `${templateTbl}.title`,
    `${templateTbl}.subject`,
    `${templateTbl}.contents`,
    `${templateTbl}.type`,
  ];
  const sql = `SELECT ${attributes.join(
    ", "
  )} FROM ${templateTbl} WHERE id = ? LIMIT 1`;

  const result = await dbQuery(sql, [templateId]);
  if (result.length === 0) throw new Error("Invalid template id");

  const { subject, contents } = result[0];

  let contentWithVariables = contents;
  let subjectWithVariables = subject;
  let schoolDetails = undefined;

  


  // Reuqire School Id
  if (contents) {

    
    const school = new RegExp(/\[.*\SCHOOLNAME\b.*\]/g);
    if (school.test(contents)) {
      if (!school_id) {
        throw new Error("school_id is required for this template");
      }
      const doesSchoolExist = await checkSchoolExist(school_id);
      if (!doesSchoolExist) throw new Error("Invalid school_id");
      schoolDetails = await getSchoolsBasicDetails(school_id);
      // Replace template content variables
      contentWithVariables = contents
        .replace(/\[.*\SCHOOLLOGO\b.*\]/g, schoolDetails.school_logo)
        .replace(/\[.*\SCHOOLNAME\b.*\]/g, schoolDetails.school_name)
        .replace(/\[.*\PAGEURL\b.*\]/g, schoolDetails.school_url)
        .replace(/\[.*\ABOUT\b.*\]/g, schoolDetails.about_school);
      subjectWithVariables = subject.replace(
        /\[.*\SCHOOLNAME\b.*\]/g,
        schoolDetails.school_name
      );
    }
  }

    // Send mail to all recipients
  recipientsFields.forEach(async(recipient) => {
    if(result[0].type=='sms')
    {


      

    //////////////// SHNAI's CODE///////////////////
  
    

    let lastdate = new Date();
    lastdate.setDate(lastdate.getDate() + 7);
    lastdate=lastdate.toISOString().slice(0,10)
    lastdate=lastdate.split("-").reverse().join("-");


     const results = await dbQuery(`SELECT course_fee, application_fee FROM engineering_institute_course
    JOIN engineering_institute on engineering_institute.e_id=engineering_institute_course.e_id
    WHERE 1=1 AND c_id = ? LIMIT 1`, [recipient.courseid]);
    
     
    const smstemplate= contentWithVariables
    .replace("[NAME]", recipient.name)
    .replace("[DATE]", lastdate)
    // .replace("[COURSEFEE]", recipient.course_fee)
    .replace("[COURSEFEE]",  results[0].course_fee )
    .replace("[COURSE]", recipient.course? recipient.course.substring(0, 30).replace(/-/g,' '):" ") 
    .replace("[REGFEE]", results[0].application_fee)
    .replace("[LINK]", `/?ext=${recipient.us_id}`)
    .replace("[COLLEGE]", recipient.college?recipient.college.substring(0, 30).replace(/-/g,' '):" ");
    



     



    const numberString = recipient.mobile.toString();
    const last10Digits = numberString.slice(-10);
    const smsURL = `http://sms.mishtel.net/api/mt/SendSMS?user=${SMS_USERNAME}&password=${SMS_PSWD}&senderid=${SENDER_ID}&channel=Trans&DCS=0&flashsms=0&number=91${last10Digits}&text=${smstemplate}&route=1`;  
    const smsOptions = {
    method: "GET",
    url: smsURL,
    headers: {
    "Content-Type": "application/x-www-form-urlencoded",
    },
    };

  axios(smsOptions)
    .then((response) => {
      if(response.data.ErrorCode !== '000') throw response.data.ErrorMessage;
      // resOtp = otp;
      // return res.status(200).json({
      //   success: true,
      //   message: "OTP sent successfully",
      // });
    })
  //   .catch((error) => {
  //     console.log(error);
  //     return res.status(500).json({
  //       success: false,
  //       message: "OTP not sent",
  //     });
  //   });

    //////////////// SHNAI's CODE END///////////////////

    }
    else
    {

    const mailOptions = {
      from: EMAIL_FROM,
      to: recipient.email,
      subject: subjectWithVariables,
      html: contentWithVariables,
    };
    transporter.sendMail(mailOptions, (error, info) => {
      if (error) {
        return res.status(500).json({
          success: false,
          message: "Error in sending mail",
          error: error.message,
        });
      }
    });
  }
  });

  


  

  return res
    .status(200)
    .json({ success: true, message: "Mails sent successfully" });
});



const get_studyindiaEnquiry_partner = tryCatch(async (req, res) => {
  const { page = 1, limit = 50, search } = req.query;
  if (Number(page) < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = (page - 1) * limit;


  
  const sid = await getSinglevalueByid("sid","school_detail","buyer_name",req.query.us_id);

  

  const queryMap = {
    table: STUDY_INDIA,
    attributes: [
      `${table}.s_id`,
      `${table}.name`,
      `${table}.mobile`,
      `${table}.parent_name`,
      `${table}.email`,
      `${table}.school_grade`,
      `${table}.school_type`,
      `${table}.current_location`,
      `${table}.edu_interest`,
      `${table}.city`,
      `${table}.mailsent AS mail_sent`,
      `${table}.currentpageurl AS url`,
      `${table}.post_date`,
      `${table}.npf_response`,
      `${SCHOOL_DETAIL}.school_name`,
       `${table}.budget`,
    ],
    additional: [
      `ORDER BY ${STUDY_INDIA}.s_id DESC`,
      `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
    conditions: [],
    parameters: [],
    joinTbl: [
      `LEFT JOIN ${SCHOOL_DETAIL} ON ${SCHOOL_DETAIL}.sid = ${STUDY_INDIA}.school_id`,
    ],
  };

  // if (search) {
  //   queryMap.conditions.push(`name LIKE ? OR email LIKE ? OR mobile LIKE ?`);
  //   queryMap.parameters.push(`%${search}%`, `%${search}%`, `%${search}%`);
  // }


  if (sid){
    queryMap.conditions.push(`school_id =?`);
    queryMap.parameters.push(`${sid.sid}`);
  }

  const { result, total } = await getEnquiryPaginationService(queryMap);
  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });

});


const assign_leads = tryCatch(async (req, res) => {
  const schoolid = await getSinglevalueByid("sid","school_detail","school_url",req.body.search);
  let sid=[]
  req.body.selectedEnquery.forEach(obj => {
    sid.push(obj.s_id)
});
  



  const sql = `UPDATE study_india SET school_id = ?   WHERE s_id IN (?);`;
  const result = dbQuery(sql, [schoolid.sid, sid]);
  
  
  return res.status(200).json({
        success: true,
        message: "Lead Assigned Successfully!",
      });

 
})

module.exports = {
  get_studyindiaEnquiry,
  update_studyindiaEnquiry,
  del_studyindiaEnquiry,
  getStudyIndiaEnquiryDetails,
  sendEnquiryMailToStudent,
  sendBulkEnquiryMailToStudents,
  get_studyindiaEnquiry_partner,
  assign_leads,
};
