const tryCatch = require("../../../../../utils/tryCatch");
const {
  TBL_PARTNER_STUDENT_QUERY,
  SC_USER,
  TBL_STUDENT_CART,
  TBL_SCHOOL_STUDENT,
  STATE_TBL,
  CITY_TBL,
  BUYER_ORDER_DETAILS,
  C_COURSE,
  PARTNER_STUDENT_DOC,
} = require("../../../../../models/tables");
const {
  getEnquiryPaginationService,
  deleteEnquiryService,
  updateEnquiryService,
  deleteAdmissionService,
} = require("../../../../../services/enquiry.service");
const {
  getScUserPaginationService,
} = require("../../../../../services/sc_user.service");


const {
  getPayments,
  getDocs,
} = require("../../../../../services/college.service");


const { getSinglevalueByid } = require("../../../../../utils/leadAccessCheck");

// @desc Get all student dashboard Enquiry
// @route GET /api/v1/admin/enquiry/student
// @access Private ADMIN
const get_studentEnquiry = tryCatch(async (req, res) => {
  const { page = 1, limit = 50, search } = req.query;
  if (Number(page) < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = (page - 1) * limit;

  const queryMap = {
    table: TBL_PARTNER_STUDENT_QUERY,
    attributes: [`${TBL_PARTNER_STUDENT_QUERY}.*`],
    conditions: [],
    parameters: [],
    additional: [
      `ORDER BY ${TBL_PARTNER_STUDENT_QUERY}.date DESC`,
      `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
  };

  if (search) {
    queryMap.conditions.push(`${TBL_PARTNER_STUDENT_QUERY}.us_username LIKE ?`);
    queryMap.parameters.push(`%${search}%`);
  }

  const { result, total } = await getEnquiryPaginationService(queryMap);

  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });
});

// @desc Reply student dashboard Enquiry
// @route PUT /api/v1/admin/enquiry/student
// @access Private ADMIN
const update_studentEnquiry = tryCatch(async (req, res) => {
  const { sl, reply } = req.body;
  if (!sl || !reply) {
    res.statusCode = 400;
    throw new Error("sl Id or Reply not added");
  }

  const queryMap = {
    update: [`reply = ?`, `reply_dt = NOW()`],
    conditions: [`${TBL_PARTNER_STUDENT_QUERY}.sl = ?`],
    parameters: [reply, sl],
    table: TBL_PARTNER_STUDENT_QUERY,
  };

  const result = await updateEnquiryService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Error while replying to student");
  }

  return res.status(200).json({
    success: true,
    message: "Replied successfully to the student",
  });
});


const update_sc_user_remark = tryCatch(async (req, res) => {

  const { us_id } = req.params;
  const { remark,remark_cause,erp } = req.body;

 
  
  if (!us_id || !remark) {
    res.statusCode = 400;
    throw new Error("Us ID or Remark not added");
  }

  const queryMap = {
    update: [`erp = ?`,`remark = ?`, `remark_cause=?`, `remark_date = NOW()`],
    conditions: [`${SC_USER}.us_id = ?`],
    parameters: [erp,
      remark,
      remark_cause,
      us_id
      ],
    table: SC_USER,
  };

  const result = await updateEnquiryService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Error while replying to student");
  }

  return res.status(200).json({
    success: true,
    message: "Replied successfully to the student",
  });
});

// @desc Delete student dashboard Enquiry
// @route DELETE /api/v1/admin/enquiry/student
// @access Private ADMIN
const del_studentEnquiry = tryCatch(async (req, res) => {
  const { sl } = req.body;
  if (!sl) throw new Error("sl ID is required");

  const queryMap = {
    table: TBL_PARTNER_STUDENT_QUERY,
    conditions: [`${TBL_PARTNER_STUDENT_QUERY}.sl = ?`],
    parameters: [sl],
  };

  const result = await deleteEnquiryService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Error while deleting the student query");
  }

  return res.status(200).json({
    success: true,
    message: "Student query deleted successfully",
  });
});

const del_AdmissionEnquiry = tryCatch(async (req, res) => {
  const { sl } = req.body;
  if (!sl) throw new Error("sl ID is required");
  // const { sl }=36896

  const queryMap = {
    table: SC_USER,
    conditions: [`${SC_USER}.us_id = ?`],
    parameters: [sl],
  };

  const result = await deleteAdmissionService(queryMap);

  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Error while deleting the student query");
  }

  return res.status(200).json({
    success: true,
    message: "Student query deleted successfully",
  });
});

/**
 * @desc get admission enquiry from signup student for school / college
 * @route /api/v1/admin/enquiry/admission/school|college
 * @access private ADMIN
 */
const getAdmissionEnquiry = tryCatch(async (req, res) => {
  const { page = 1, limit = 50, search, user } = req.query;


  

  let userrestrict=''
  if (user) {
    const assign_college = await getSinglevalueByid(
      "assign_college",
      "cms_admin",
      "id",
      user
    );
    const array = assign_college.assign_college?assign_college.assign_college.split(","):'';
    let cs = "";
    for (var i = 0; i < array.length; i++) {
      let or = " or ";
      if (array.length - 1 == i) {
        or = "";
      } else {
        or = " or ";
      }

      cs += "sc_user.url='" + array[i] + "'" + or;
    }

     userrestrict=cs?"("+cs+")":'';
    
  }

  

  if (Number(page) < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = (page - 1) * limit;

  const { type } = req.params;

  const queryMap = {
    attributes: [],
    conditions: [],
    parameters: [],
    additional: [],
    joinTbl: [],
  };

  switch (type) {
    case "school":
      queryMap.attributes.push(
        ...[
          `${SC_USER}.us_id`,
          `${SC_USER}.us_username`,
          `${SC_USER}.mobile_1`,
          `${TBL_STUDENT_CART}.std AS class`,
          `${TBL_STUDENT_CART}.institute_name AS school`,
          `${SC_USER}.erp`,
          `${TBL_STUDENT_CART}.date`,
          `${TBL_SCHOOL_STUDENT}.full_name AS student_name`,
          `${TBL_STUDENT_CART}.payment_status`,
          `${TBL_SCHOOL_STUDENT}.dob`,
          `${SC_USER}.parent_name AS father_name`,
          `${SC_USER}.mother_name`,
          `${STATE_TBL}.state`,
          `${SC_USER}.city`,
          // `${CITY_TBL}.cname AS city`,
          `${TBL_SCHOOL_STUDENT}.id AS student_id`,
          `${SC_USER}.npf_response`,
        ]
      );
      queryMap.conditions.push(
        `(${SC_USER}.user_type = ? OR ${SC_USER}.user_type = ?)`
      );
      queryMap.parameters.push("school", "student");

      queryMap.additional.push(
        `ORDER BY ${TBL_STUDENT_CART}.date DESC`,
        `LIMIT ${Number(limit) || 10} OFFSET ${offset}`
      );
      queryMap.joinTbl.push(
        `INNER JOIN ${TBL_STUDENT_CART} ON ${TBL_STUDENT_CART}.us_id = ${SC_USER}.us_id`,
        `INNER JOIN ${TBL_SCHOOL_STUDENT} ON ${TBL_SCHOOL_STUDENT}.us_id = ${SC_USER}.us_id`,
        `INNER JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${SC_USER}.state OR ${STATE_TBL}.state LIKE ${SC_USER}.state)`
        // `INNER JOIN ${CITY_TBL} ON (${CITY_TBL}.ctid = ${SC_USER}.city OR ${CITY_TBL}.cname LIKE ${SC_USER}.city)`
      );
      if (search) {
        queryMap.conditions.push(
          `(${TBL_SCHOOL_STUDENT}.full_name LIKE ? OR ${TBL_STUDENT_CART}.institute_name LIKE ? OR ${SC_USER}.us_username LIKE ?  OR ${SC_USER}.mobile_1 like ?)`
        );
        queryMap.parameters.push(
          `%${search}%`,
          `%${search}%`,
          `%${search}%`,
          `%${search}%`
        );
      }
      //  console.log(queryMap)
      break;

    case "college":
      ///////////////////// THis is original code develop by developer /////////////////////////////////////
      // queryMap.attributes.push(
      //   ...[
      //     `${SC_USER}.us_fname`,
      //     `${SC_USER}.us_lname`,
      //     `${SC_USER}.us_id`,
      //     `${SC_USER}.us_username`,
      //     `${SC_USER}.mobile_1`,
      //     `${SC_USER}.url`,
      //     `${SC_USER}.course`,
      //     `${SC_USER}.specialization`,
      //     `${SC_USER}.us_create_date`,
      //     //`${TBL_STUDENT_CART}.std AS class`,
      //    // `${TBL_STUDENT_CART}.institute_name AS school`,
      //     `${SC_USER}.erp`,
      //     `${C_COURSE}.course_name`,
      //     `${C_COURSE}.specialization`,
      //     `${SC_USER}.parent_name AS father_name`,
      //     `${SC_USER}.mother_name`,
      //     `${STATE_TBL}.state`,
      //     `${CITY_TBL}.cname AS city`,
      //     `${SC_USER}.npf_response`,
      //   ]
      // );
      // // queryMap.conditions.push(
      // //   `(${SC_USER}.user_type = ? OR ${SC_USER}.user_type = ?)`
      // // );
      // queryMap.parameters.push("user_type", "partner");

      // queryMap.additional.push(
      //   `ORDER BY ${SC_USER}.us_id DESC`,
      //   `LIMIT ${Number(limit) || 10} OFFSET ${offset}`
      // );
      // queryMap.joinTbl.push(
      //   // `INNER JOIN ${TBL_STUDENT_CART} ON ${TBL_STUDENT_CART}.us_id = ${SC_USER}.us_id`,
      //   // `INNER JOIN ${TBL_SCHOOL_STUDENT} ON ${TBL_SCHOOL_STUDENT}.us_id = ${SC_USER}.us_id`,
      //   `INNER JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${SC_USER}.state)`,
      //   `INNER JOIN ${CITY_TBL} ON (${CITY_TBL}.ctid = ${SC_USER}.city)`,
      //   `INNER JOIN ${C_COURSE} ON (${C_COURSE}.c_id = ${SC_USER}.course)`
      // );
      // if (search) {
      //   queryMap.conditions.push(`(${SC_USER}.us_fname LIKE ? OR ${SC_USER}.us_lname LIKE ? OR ${SC_USER}.us_username LIKE ? OR ${SC_USER}.url LIKE ?)`);
      //   queryMap.parameters.push(`%${search}%`, `%${search}%`, `%${search}%`, `%${search}%`);
      // }
      // // console.log("college calling")
      // break;

      ///////////////////// THis is original code develop by developer end /////////////////////////////////////

      queryMap.attributes.push(
        ...[
          `${SC_USER}.us_fname`,
          `${SC_USER}.us_lname`,
          `${SC_USER}.us_id`,
          `${SC_USER}.us_username`,
          `${SC_USER}.mobile_1`,
          `${SC_USER}.url`,
          `${SC_USER}.course`,
          `${SC_USER}.us_create_date`,
          `${SC_USER}.erp`,
          `${SC_USER}.remark`,
          `${SC_USER}.remark_cause`,
          `${SC_USER}.remark_date`,
          `${SC_USER}.parent_name AS father_name`,
          `${SC_USER}.mother_name`,
          `${SC_USER}.npf_response`,
          `${SC_USER}.payment_status`, 
        ]
      );

      queryMap.conditions.push(`(${SC_USER}.user_type = 'partner')`);

      if(userrestrict){
      queryMap.conditions.push(userrestrict);
      }
      
      queryMap.attributes.push(
        `CASE WHEN ${SC_USER}.course>0  THEN (select course_name from ${C_COURSE} where c_id=${SC_USER}.course) ELSE ${SC_USER}.course END AS course_name`
      );
      queryMap.attributes.push(
        `CASE WHEN ${SC_USER}.course>0  THEN (select  specialization from ${C_COURSE} where c_id=${SC_USER}.course) ELSE ${SC_USER}.specialization  END AS specialization`
      );

      queryMap.attributes.push(
        `CASE WHEN ${SC_USER}.state>0  THEN (select  state from ${STATE_TBL} where ${STATE_TBL}.sid=${SC_USER}.state) ELSE ${SC_USER}.state END AS state`
      );

      queryMap.attributes.push(
        `CASE WHEN ${SC_USER}.city>0  THEN (select  cname from ${CITY_TBL} where ${CITY_TBL}.ctid=${SC_USER}.city) ELSE ${SC_USER}.city  END AS city`
      );

      queryMap.parameters.push("user_type", "partner");

      queryMap.additional.push(
        `ORDER BY ${SC_USER}.us_id DESC`,
        `LIMIT ${Number(limit) || 10} OFFSET ${offset}`
      );

      // queryMap.joinTbl.push(
      //   `INNER JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${SC_USER}.state)`,
      //   `INNER JOIN ${CITY_TBL} ON (${CITY_TBL}.ctid = ${SC_USER}.city)`,
      // );

      if (search) {
        queryMap.conditions.push(
          `(${SC_USER}.us_fname LIKE ? OR ${SC_USER}.us_lname LIKE ? OR ${SC_USER}.us_username LIKE ? OR ${SC_USER}.url LIKE ?  OR ${SC_USER}.mobile_1 like ? )`
        );
        queryMap.parameters.push(
          `%${search}%`,
          `%${search}%`,
          `%${search}%`,
          `%${search}%`,
          `%${search}%`
        );
      }
      // console.log("college calling")

      break;

    default:
      res.statusCode = 400;
      throw new Error("Invalid type");
  }

  const { result, total } = await getScUserPaginationService(queryMap);
  // console.log("Hi shani",req.query);
  // console.log("type",type);



  const userwithPayments = await setPayments(result);

  const userwithdoc = await setDocument(userwithPayments)
  

  return res.status(200).json({
    success: true,
    data: userwithdoc,
    records: total,
  });
});


const setPayments = async (users) => {

  const userwithPayments = [];
  for (let i = 0; i < users.length; i++) {
    const user = users[i];
    const queryMapPayments = {
      attributes: [
        `${BUYER_ORDER_DETAILS}.BUYER_ID`,
        `${BUYER_ORDER_DETAILS}.PAYMENT_SOURCE`,
        `${BUYER_ORDER_DETAILS}.TXNID`,
        `${BUYER_ORDER_DETAILS}.ORDERID`,
        `${BUYER_ORDER_DETAILS}.TXNAMOUNT`,
        `${BUYER_ORDER_DETAILS}.TXNDATE`,
        `${BUYER_ORDER_DETAILS}.STATUS`,
        `${SC_USER}.us_fname AS name`,
      ],
      conditions: [
        `${BUYER_ORDER_DETAILS}.BUYER_ID = ? and STATUS='TXN_SUCCESS' order by BOD_ID desc`,
      ],
      parameters: [
        users[i].us_id,
        []
         
      ],
      additional: [`LIMIT 5`],
      joinTbl: [
        `LEFT JOIN ${SC_USER} ON ${SC_USER}.us_id = ${BUYER_ORDER_DETAILS}.BUYER_ID`,
      ],  
    };
    const payResult = await getPayments(queryMapPayments);
    userwithPayments.push({
      ...user,
      payments: payResult,
    });
  }
  return userwithPayments;
};

const setDocument = async (users) => {

  const UserDoc = [];
  for (let i = 0; i < users.length; i++) {
    const user = users[i];
    const queryMyDoc = {
      attributes: [
        `${PARTNER_STUDENT_DOC}.profile_pic`,
        `${PARTNER_STUDENT_DOC}.aadhar_front`,
        `${PARTNER_STUDENT_DOC}.aadhar_back`,
        `${PARTNER_STUDENT_DOC}.ten_marksheet`,
        `${PARTNER_STUDENT_DOC}.twel_marksheet`,
        `${PARTNER_STUDENT_DOC}.gradut_marksheet`,
        `${PARTNER_STUDENT_DOC}.post_graduate`,
        `${PARTNER_STUDENT_DOC}.caste`,
        `${PARTNER_STUDENT_DOC}.income`,
        `${PARTNER_STUDENT_DOC}.fee_receipt`,
        `${PARTNER_STUDENT_DOC}.form`, 
        `${PARTNER_STUDENT_DOC}.signature `,
        `${PARTNER_STUDENT_DOC}.neet_score_card`, 
      ],
      conditions: [
        `${PARTNER_STUDENT_DOC}.us_id = ?`,
      ],
      parameters: [
        users[i].us_id,
        []
         
      ],
      additional: [`LIMIT 5`],
      joinTbl: [
        `LEFT JOIN ${SC_USER} ON ${SC_USER}.us_id = ${PARTNER_STUDENT_DOC}.us_id`,
      ],  
    };
    const DocResult = await getDocs(queryMyDoc);
    UserDoc.push({
      ...user,
      documents: DocResult,
    });
  }
  return UserDoc;
};

module.exports = {
  get_studentEnquiry,
  update_studentEnquiry,
  del_studentEnquiry,
  del_AdmissionEnquiry,
  getAdmissionEnquiry,
  update_sc_user_remark
};
