const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { C_COURSE, COURSE, SPECIALIZATION, COURSE_DELIVERY, COURSELEVEL, CATEGORY} = require("../../../../models/tables");
const { getCollegeCoursePaginationService, deleteCollegeCourseService, updateCollegeCourseService, addNewCollegeCourseService } = require("../../../../services/college.service")
const { getSinglevalueByid }  = require("../../../../utils/leadAccessCheck")

const table = C_COURSE;

// @desc get college course using :id param of college
// @api GET api/v1/admin/college-course/:e_id
// @access private
const get_collegeCourse = tryCatch(async (req, res) => {

  const { page = 1, limit = 50, search } = req.query;
  if(Number(page) < 1) throw new Error("Page number is required and should be greater than 0");
  const offset = (page - 1) * limit;

  const { e_id } = req.params;

  const queryMap = {
    attributes: [
      `${C_COURSE}.*`,
      `${CATEGORY}.cat_name AS course_category`,
      `${COURSE}.course_name AS course_name`,
      `${SPECIALIZATION}.spce_name AS specialization`,
      `${COURSE_DELIVERY}.name AS mode_learning`,
      `${COURSELEVEL}.name AS course_level`,
    ],
    conditions: [`${C_COURSE}.e_id = ?`],
    parameters: [e_id],
    additional: [`GROUP BY ${C_COURSE}.c_id`, `ORDER BY ${C_COURSE}.update_date DESC`,`LIMIT ${Number(limit)} OFFSET ${offset}`],
    joinTbl: [
      `LEFT JOIN ${COURSE} ON (${COURSE}.course_id = ${C_COURSE}.course_name OR ${COURSE}.course_name = ${C_COURSE}.course_name)`,
      `LEFT JOIN ${CATEGORY} ON (${CATEGORY}.cat_id = ${C_COURSE}.course_category OR ${CATEGORY}.cat_name = ${C_COURSE}.course_category)`,
      `LEFT JOIN ${SPECIALIZATION} ON (${SPECIALIZATION}.spec_id = ${C_COURSE}.specialization OR ${SPECIALIZATION}.spce_name = ${C_COURSE}.specialization)`,
      `LEFT JOIN ${COURSE_DELIVERY} ON (${COURSE_DELIVERY}.id = ${C_COURSE}.mode_learning OR ${COURSE_DELIVERY}.name = ${C_COURSE}.mode_learning)`,
      `LEFT JOIN ${COURSELEVEL} ON (${COURSELEVEL}.id = ${C_COURSE}.course_level OR ${COURSELEVEL}.name = ${C_COURSE}.course_level)`
    ],
    distinctCount: `${C_COURSE}.c_id`
  }

  if(search){
    queryMap.conditions.push(`(${CATEGORY}.cat_name LIKE ? OR ${COURSE}.course_name LIKE ? OR ${SPECIALIZATION}.spce_name LIKE ?)`);
    queryMap.parameters.push(`'%${search}%'`,`'%${search}%'`, `'%${search}%'`)
  }

  const { result, total } = await getCollegeCoursePaginationService(queryMap);

  return res.status(200).json({
    success: true,
    data: result,
    records: total
  })

});

// @desc add college course
// @api POST api/v1/admin/college-course/:e_id
// @access private ADMIN
const post_collegeCourse = tryCatch(async (req, res) => {

  const { e_id } = req.params;


  


  if(!req.body.course_category){
    res.statusCode = 400;
    throw new Error("course_category is required");
  }

  const fields = setNewCollegeCourseAttributes();

  const queryMap = {
    attributes: fields.concat(["added_by", "updated_by", "insert_date", "update_date"]),
    parameters: fields.map((field) => req.body[field]).concat(["admin", "admin", new Date(), new Date()]),
  }


  
  const getCategory = await getSinglevalueByid("cat_name","category","cat_id",queryMap.parameters[2]);
  const getCourse = await getSinglevalueByid("course_name","course","course_id",queryMap.parameters[3]);
  const getspecialization = await getSinglevalueByid("spce_name","specialization","spec_id",queryMap.parameters[4]);

  
  queryMap.parameters[2]=getCategory.cat_name
  queryMap.parameters[3]=getCourse.course_name
  queryMap.parameters[4]=getspecialization.spce_name
  // console.log(queryMap.parameters)
  

  const result = await addNewCollegeCourseService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error, while adding new college course");
  };

  return res.status(200).json({
    success: true,
    message: "College course added successfully"
  });

});

// @desc update college course
// @api PUT api/v1/admin/college-course/:e_id
// @access private ADMIN
const update_collegeCourse = tryCatch(async (req, res) => {
 
  const { e_id } = req.params;

  const { c_id, update } = req.body;
  if(!Number(c_id) < 0 || !update) throw new Error("c_id is required");

  const { column, value } = updateColumn(update);

  const queryMap = {
    update: [column, `update_date = NOW()`],
    conditions: [`${C_COURSE}.e_id = ?`, `${C_COURSE}.c_id = ?`],
    parameters: [...value, e_id, c_id],
  };

  
  const result = await updateCollegeCourseService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error, while updating this college course");
  }

  return res.status(200).json({
    success: true,
    message: "College course updated successfully"
  }); 

});

// @desc delete college course
// @api DELETE api/v1/admin/college-course/:e_id
// @access private ADMIN
const del_collegeCourse = tryCatch(async (req, res) => {

  const { e_id } = req.params;

  const { c_id } = req.body;
  if(!Number(c_id) < 0) throw new Error("c_id is required");

  const queryMap = {
    conditions: [`${C_COURSE}.e_id = ?`, `${C_COURSE}.c_id = ?`],
    parameters: [e_id, c_id],
  }

  const result = await deleteCollegeCourseService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error, while deleting this college course");
  };

  return res.status(200).json({
    success: true,
    message: "College course deleted successfully"
  });

});

module.exports = {
  get_collegeCourse,
  post_collegeCourse,
  update_collegeCourse,
  del_collegeCourse,
};


const setNewCollegeCourseAttributes = () => {
  return [
    "e_id",
    "c_id",
    "course_category",
    "course_name",
    "specialization",
    "course_duration",
    "course_duration_type",
    "mode_learning",
    "course_level",
    "course_fee",
    "silent_feature",
  ];
}