const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { C_MEDIA } = require("../../../../models/tables");

const table = C_MEDIA;

// @desc get college using :id param of college
// @api GET api/v1/admin/college-media/:e_id
// @access private
const get_collegeMedia = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { e_id } = req.params;
  if(!e_id) throw new Error(`No id found`);
  sql = `SELECT * FROM ${table} WHERE e_id = ?`;
  result = await dbQuery(sql, [e_id]);
  if (result.length === 0) errorMsgEmpty("No data found", res);
  return res.status(200).json({ sucess: true, data: result[0] });
});

// @desc post college media
// @api POST api/v1/admin/college-media/:e_id
// @access private ADMIN
const post_collegeMedia = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { e_id } = req.params;
  if(!e_id) throw new Error(`No id found`);
  sql = `SELECT * FROM ${table} WHERE e_id = ?`;
  result = await dbQuery(sql,[e_id]);
  const {
    image1 = null,image2 = null,image3 = null,image4 = null,image5 = null,image6 = null,
    title1 = null,title2 = null,title3 = null,title4 = null,title5 = null,title6 = null,
    vtitle1 = null,vtitle2 = null,vtitle3 = null,vtitle4 = null,
    video1 = null,video2 = null,video3 = null,video4 = null,
    added_by,updated_by,
  } = req.body;
  sql = `INSERT INTO ${table} (e_id,image1,image2,image3,image4,image5,image6,title1,title2,title3,title4,title5,title6,vtitle1,vtitle2,vtitle3,vtitle4,video1,video2,video3,video4,added_by,updated_by,insert_date) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
  result = await dbQuery(sql,[
    e_id,image1,image2,image3,image4,image5,image6,title1,title2,title3,title4,title5,title6,vtitle1,vtitle2,vtitle3,vtitle4,video1,video2,video3,video4,'admin','admin'
  ]);
  if (result.affectedRows === 0) throw new Error(`Error! cant insert data`);
  return res.status(200).json({ sucess: true, message:'Media added' });
});

// @desc update college media
// @api PUT api/v1/admin/college-media/:e_id
// @access private ADMIN
const update_collegeMedia = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { i_id, update } = req.body;
  const { e_id } = req.params;
  if(!i_id || !update || !e_id) throw new Error(`No id found or update`);
  const { column, value } = updateColumn(update);
  sql = `UPDATE ${table} SET ${column},update_date = NOW() WHERE i_id = ? AND e_id = ?`;
  result = await dbQuery(sql,[...value, i_id, e_id]);
  if (result.affectedRows === 0) throw new Error(`Error! cant update data`);
  return res.status(200).json({ sucess: true, message:'Media updated' });

});

// @desc delete college media
// @api DELETE api/v1/admin/college-media/:e_id
// @access private ADMIN
const del_collegeMedia = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { i_id } = req.body;
  const { e_id } = req.params;
  if(!i_id || !e_id) throw new Error(`No id found`);
  sql = `DELETE FROM ${table} WHERE i_id = ? AND e_id = ?`;
  result = await dbQuery(sql,[i_id,e_id]);
  if (result.affectedRows === 0) throw new Error(`Error! cant delete data`);
  return res.status(200).json({ sucess: true, message:'Media deleted' });
});

module.exports = { get_collegeMedia, post_collegeMedia, update_collegeMedia, del_collegeMedia };
