const tryCatch = require("../../../../utils/tryCatch");
const { COMPANY_PLACEMENT, C_INSTITUTE } = require("../../../../models/tables");
const { getCompanyPlacementService } = require("../../../../services/master/companyPlacement.service");
const { getCollegeService, updateCollegeService } = require("../../../../services/college.service");

// @desc    Get Placement Details
// @api   GET /api/v1/admin/college-placement/:e_id
// @access  Private
const get_placementDetails = tryCatch(async (req, res) => {

  const { e_id } = req.params;

  const { limit = 30, search } = req.query;

  const queryMapCompanyFromCollege = {
    attributes: [`${C_INSTITUTE}.placement_company_list`],
    conditions: [`${C_INSTITUTE}.e_id = ?`],
    parameters: [e_id],
  };

  const companyList = await getCollegeService(queryMapCompanyFromCollege);

  const queryMapCompany = {
    attributes: [`${COMPANY_PLACEMENT}.com_id`, `${COMPANY_PLACEMENT}.company_name`, `${COMPANY_PLACEMENT}.company_logo`],
    conditions: [`${COMPANY_PLACEMENT}.com_id IN (${companyList[0].placement_company_list})`],
    parameters: [],
    additional: [`LIMIT ${Number(limit) || 30}`],
  };

  if (search) {
    queryMapCompany.conditions.push(`${COMPANY_PLACEMENT}.company_name LIKE ?`);
    queryMapCompany.parameters.push(`${search}%`);
  };

  const result = await getCompanyPlacementService(queryMapCompany);
  if (result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while fetching company placement");
  };

  return res.status(200).json({
    success: true,
    data: result,
  });

});

// @desc    Update Placement Details
// @api   PUT /api/v1/admin/college-placement/:e_id
// @access  Private
const update_placementDetails = tryCatch(async (req, res) => {
 
  const { e_id } = req.params;

  const { company } = req.body;
  if (!company){
    res.statusCode = 400;
    throw new Error("company required");
  };

  const queryMap = {
    update: `placement_company_list = ?`,
    conditions: [`${C_INSTITUTE}.e_id = ?`],
    parameters: [company, e_id],
  };

  const result = await updateCollegeService(queryMap);
  if (result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while updating company placement");
  };

  return res.status(200).json({
    success: true,
    message: "Company placement list updated",
  });

});

module.exports = {
  get_placementDetails,
  update_placementDetails,
};
