const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { CITY_TBL } = require("../../../../models/tables");

const table = CITY_TBL;

// @desc  Get all school college city
// @route GET /api/v1/admin/college-city
// @access  Private
const get_collegeCity = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let qry = "";
  let { search, page, limit = 50 } = req.query;
  if (!page || page < 1) throw new Error("Invalid page number");
  const offset = (page - 1) * limit;
  if (search) qry += `AND cname LIKE '${search}%'`;
  sql = `SELECT ctid AS cityId, cname AS cityName, sid AS state_id FROM ${table} WHERE 1=1 ${qry} LIMIT ${limit} OFFSET ${offset}`;
  result = await dbQuery(sql);
  let total = await dbQuery(
    `SELECT COUNT(*) as records FROM ${table} WHERE 1=1 ${qry}`
  );
  const { records } = total[0];
  if (result.length === 0) errorMsgEmpty("No data found", res);
  res.status(200).json({ success: true, data: result, records });
});

// @desc Post new college city
// @route POST /api/v1/admin/college-city
// @access  Private ADMIN
const post_collegeCity = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { cityName, parentId } = req.body;
  if (!cityName || !parentId)
    throw new Error("Please fill all required fields");
  sql = `INSERT INTO ${table} (cname, sid) VALUES (?, ?)`;
  result = await dbQuery(sql, [cityName, parentId]);
  if (result.affectedRows === 0) throw new Error("Failed to add new city");
  res.status(200).json({ success: true, message: "New city added" });
});

// @desc  Update college city
// @route PUT /api/v1/admin/college-city
// @access  Private ADMIN
const update_collegeCity = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { cityId, update } = req.body;
  if (!cityId || !update) throw new Error("cityId and update object required");
  // const { column, value } = updateColumn(update);
  sql = `UPDATE ${table} SET cname = '${update.cityName}', sid = ${update.parentId}  WHERE ctid = ?`;
  result = await dbQuery(sql, [cityId]);
  if (result.affectedRows === 0) throw new Error("Failed to update city");
  res.status(200).json({ success: true, message: "City updated" });
});

// @desc  Delete college city
// @route DELETE /api/v1/admin/college-city
// @access  Private ADMIN
const del_collegeCity = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { cityId } = req.body;
  if (!cityId) throw new Error("cityId required");
  sql = `DELETE FROM ${table} WHERE ctid = ?`;
  result = await dbQuery(sql, [cityId]);
  if (result.affectedRows === 0) throw new Error("Failed to delete city");
  res.status(200).json({ success: true, message: "City deleted" });
});

module.exports = {
  get_collegeCity,
  post_collegeCity,
  update_collegeCity,
  del_collegeCity,
};
