const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { errorMsgEmpty } = require("../../../../utils/errors_message");
const { C_CONTACT } = require("../../../../models/tables");
const { collegeContactFields, collegeContactMandatoryFields } = require("./create_college_content");
const { checkCollegeExist,getSinglevalueByid } = require("../../../../utils/leadAccessCheck");

let [sql, result] = [null, null];

const table = C_CONTACT;

// @desc get college contact using :id param of college
// @api GET api/v1/admin/college-contact/:e_id
// @access private


const get_collegeContact = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { e_id } = req.params;
  if (!e_id) throw new Error(`No college id found`);
  sql = `SELECT * FROM ${table} WHERE e_id = ?`;
  result = await dbQuery(sql, [e_id]);
  if (result.length === 0) errorMsgEmpty("No data found", res);
  return res.status(200).json({ sucess: true, data: result[0] });
});

// @desc add college contact
// @api POST api/v1/admin/college-contact/:e_id
// @access private ADMIN

// const post_collegeContact = tryCatch(async (req, res) => {


//   console.log("attributes",req.body)
  
//   let [sql, result] = [null, null];
//   const { e_id } = req.params;
//   const { role, adminId } = req;
  
//   if (!e_id) throw new Error(`No college id found`);
//   const doesCollegeExist = await checkCollegeExist(e_id);
//   if (!doesCollegeExist) throw new Error(`College doesn't exist`);
  
//   const attributes = [];
//   const insertBody = [];
//   // collegeContactFields.forEach((field) => {
//   //   if(req.body[field]){
//   //     attributes.push(field);
//   //     insertBody.push(req.body[field]);
//   //   }
//   //   if(collegeContactMandatoryFields.includes(field) && !req.body[field]){
//   //     throw new Error(`${field} is required`)
//   //   }
//   // });

//   // console.log("shanisss>>",req.body)



//   // if(isNaN(req.body.update.city)===false){
//   //   const statename = await getSinglevalueByid("state","state_tbl","sid",req.body.update.state);
//   //   const city = await getSinglevalueByid("cname","city_tbl","ctid",req.body.update.city);
//   //   value[1]=city.cname;
//   //   value[11]=statename.state;
//   //   }


  

//   attributes.push("e_id");
//   insertBody.push(e_id);
//   sql = `INSERT INTO ${table} (${attributes.join(", ")},added_by, updated_by,insert_date,update_date) VALUES (${insertBody.map(item => '?')}, "admin", "admin", NOW(), NOW())`;
//   result = await dbQuery(sql, insertBody);

//   if (!result.affectedRows) throw new Error(`No data inserted`);
//   return res.status(200).json({ sucess: true, message: `Contact added` });
// });


const post_collegeContact = tryCatch(async (req, res) => {
  
  let [sql, result] = [null, null];
  const { e_id } = req.params;
  const { role, adminId } = req;
  if (!e_id) throw new Error(`No college id found`);
  const doesCollegeExist = await checkCollegeExist(e_id);
  if (!doesCollegeExist) throw new Error(`College doesn't exist`);
  const attributes = [];
  const insertBody = [];
  collegeContactFields.forEach((field) => {
    if(req.body[field]){
      attributes.push(field);
      insertBody.push(req.body[field]);
    }
    // if(collegeContactMandatoryFields.includes(field) && !req.body[field]){
    //   throw new Error(`${field} is required`)
    // }
  });
;

// if(isNaN(req.body.city)===false){
//   const statename = await getSinglevalueByid("state","state_tbl","sid",req.body.state);
//   const city = await getSinglevalueByid("cname","city_tbl","ctid",req.body.city);
//   insertBody[4]=city.cname;
//   insertBody[5]=statename.state;
  
//   }
    

  attributes.push("e_id");
  insertBody.push(e_id);

  sql = `INSERT INTO ${table} (${attributes.join(", ")},added_by, updated_by,insert_date,update_date) VALUES (${insertBody.map(item => '?')}, " ", " ", NOW(), NOW())`;  
  result = await dbQuery(sql, insertBody);

  if (!result.affectedRows) throw new Error(`No data inserted`);
  return res.status(200).json({ sucess: true, message: `Contact added` });
});

// @desc update college contact
// @api PUT api/v1/admin/college-contact/:e_id
// @access private ADMIN
const update_collegeContact = tryCatch(async (req, res) => {
 

  let [sql, result] = [null, null];
  const { e_id } = req.params;
  const { c_id, update } = req.body;
  if (!e_id || !c_id || !update) throw new Error(`Some fields are missing`);
  const doesCollegeExist = await checkCollegeExist(e_id);
  if (!doesCollegeExist) throw new Error(`College doesn't exist`);
  const { column, value } = updateColumn(update);


  ////// Fetching state/ city from id///////// shani
  // if(isNaN(req.body.update.city)===false){
  //   const statename = await getSinglevalueByid("state","state_tbl","sid",req.body.update.state);
  //   const city = await getSinglevalueByid("cname","city_tbl","ctid",req.body.update.city);
  //   value[1]=city.cname;
  //   value[11]=statename.state;
  //   }

  

  sql = `UPDATE ${table} SET ${column}, update_date = NOW() WHERE c_id = ? AND e_id = ?`;
  result = await dbQuery(sql, [...value, c_id, e_id]);
  if (!result.affectedRows) throw new Error(`No data updated`);
  return res.status(200).json({ sucess: true, message: `Contact update!` });
});

// @desc delete college contact
// @api DELETE api/v1/admin/college-contact/:e_id
// @access private ADMIN
const del_collegeContact = tryCatch(async (req, res) => {
  const { e_id } = req.params;
  const { c_id } = req.body;
  if (!e_id || !c_id) throw new Error(`Some fields are missing`);
  sql = `DELETE FROM ${table} WHERE c_id = ? AND e_id = ?`;
  result = await dbQuery(sql, [c_id, e_id]);
  if (!result.affectedRows) throw new Error(`No data deleted`);
  return res.status(200).json({ sucess: true, message: `Contact deleted!` });
});

module.exports = {
  get_collegeContact,
  post_collegeContact,
  update_collegeContact,
  del_collegeContact,
};
