const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");

const {
  TBL_PROJECTS,
  TBL_PROJECT_CATEGORY,
} = require("../../../../models/tables");

const {
  addNewService,
  getProjectsPaginationService,
  getProjectsCategoryPaginationService,
  addProjectCategory,
  updateCategoryService,
  deleteCategoryService,
  updateProjectService,
} = require("../../../../services/college.service");

const projectCreateField = [
  "project_cat",
  "name",
  "industry",
  "operation_since",
  "listing_nature",
  "of_project",
  "kms_of_roads",
  "kms_of_pipeline",
  "kms_of_transmission_line",
  "generation_capacity",
  "number_of_towers",
  "any_other",
  "asset_under_management",
  "market_capitalization",
  "no_of_unit",
  "no_of_investor",
  "unitholding_pattern",
  "sponsor_unit_holding",
  "fii_unitholding",
  "dii_unitholding",
  "corporate_trust_unitholding",
  "retail_unitholding",
  "others",
  "funding_raise_till_date",
  "equity",
  "debt",
  "annual_dpu",
  "fy23",
  "fy24p",
  "nav",
];

const get_researchInformation = tryCatch(async (req, res) => {
  const getProjectDetailsAttribute = () => {
    return {
      attributes: [
        `${TBL_PROJECTS}.id`,
        `${TBL_PROJECT_CATEGORY}.project_name as category`,
        `${TBL_PROJECTS}.name`,
        `${TBL_PROJECTS}.industry`,
        `${TBL_PROJECTS}.operation_since`,
        `${TBL_PROJECTS}.listing_nature`,
        `${TBL_PROJECTS}.of_project`,
        `${TBL_PROJECTS}.kms_of_roads`,
        `${TBL_PROJECTS}.kms_of_pipeline`,
        `${TBL_PROJECTS}.kms_of_transmission_line`,
        `${TBL_PROJECTS}.generation_capacity`,
        `${TBL_PROJECTS}.number_of_towers`,
        `${TBL_PROJECTS}.any_other`,
        `${TBL_PROJECTS}.asset_under_management`,
        `${TBL_PROJECTS}.market_capitalization`,
        `${TBL_PROJECTS}.no_of_unit`,
        `${TBL_PROJECTS}.no_of_investor`,
        `${TBL_PROJECTS}.unitholding_pattern`,
        `${TBL_PROJECTS}.sponsor_unit_holding`,
        `${TBL_PROJECTS}.fii_unitholding`,
        `${TBL_PROJECTS}.dii_unitholding`,
        `${TBL_PROJECTS}.corporate_trust_unitholding`,
        `${TBL_PROJECTS}.retail_unitholding`,
        `${TBL_PROJECTS}.others`,
        `${TBL_PROJECTS}.funding_raise_till_date`,
        `${TBL_PROJECTS}.equity`,
        `${TBL_PROJECTS}.debt`,
        `${TBL_PROJECTS}.annual_dpu`,
        `${TBL_PROJECTS}.fy23`,
        `${TBL_PROJECTS}.fy24p`,
        `${TBL_PROJECTS}.nav`,
        `${TBL_PROJECTS}.date`,
      ],
    };
  };

  const { page = 1, limit = 10, search, pid } = req.query;

  

  if (Number(page) < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = Number((page - 1) * 10);

  const queryMap = {
    attributes: getProjectDetailsAttribute().attributes,
    conditions: [],
    parameters: [],
    joinTbl: [
      `LEFT JOIN ${TBL_PROJECT_CATEGORY} ON ${TBL_PROJECT_CATEGORY}.id = ${TBL_PROJECTS}.project_cat`,
      // `LEFT JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${C_CONTACT}.state OR ${STATE_TBL}.state = ${C_CONTACT}.state)`,
      // `LEFT JOIN ${CITY_TBL} ON (${CITY_TBL}.ctid = ${C_CONTACT}.city OR ${CITY_TBL}.cname = ${C_CONTACT}.city)`
    ],
    additional: [
      // `GROUP BY ${TBL_PROJECTS}.e_id`,
      `ORDER BY ${TBL_PROJECTS}.id asc`,
      `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
    distinctCount: `${TBL_PROJECTS}.id`,
  };


  if (search) {
    queryMap.conditions.push(`${TBL_PROJECT_CATEGORY}.project_name LIKE ?`);
    queryMap.parameters.push(`%${search.replace(/-/g, ' ')}%`);
  }

  

  if (pid) {
    queryMap.conditions.push(`${TBL_PROJECTS}.id LIKE ?`);
    queryMap.parameters.push(`%${pid}%`);
  }


  if (req.params.id>0) {
    queryMap.conditions.push(`${TBL_PROJECTS}.id LIKE ?`);
    queryMap.parameters.push(`%${req.params.id}%`);
  }
  
  const { result, total } = await getProjectsPaginationService(queryMap);

  

  return res.status(200).json({
    status: true,
    data: result,
    records: total,
  });
});

const post_researchInformation = tryCatch(async (req, res) => {
  const queryMap = {
    attributes: [...projectCreateField, "date"],
    parameters: [
      ...projectCreateField.map((field) => req.body[field]),
      new Date(),
    ],
  };

  const result = await addNewService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Failed to insert new project");
  }

  return res
    .status(200)
    .json({ success: true, message: "Project Added Successfully" });
});

const get_project_cat = tryCatch(async (req, res) => { 

  
  
  const getCategoryAttribute = () => {
    return {
      attributes: [
        `${TBL_PROJECT_CATEGORY}.id`,
        `${TBL_PROJECT_CATEGORY}.project_name`,
        `${TBL_PROJECT_CATEGORY}.description`,
        `${TBL_PROJECT_CATEGORY}.active`,
        `${TBL_PROJECT_CATEGORY}.priority`,
      ],
    };
  };

  const queryMap = {
    attributes: getCategoryAttribute().attributes,
    conditions: [],
    parameters: [],

    conditions: [`${TBL_PROJECT_CATEGORY}.active = 'Y'`],
    
    joinTbl: [
      // `LEFT JOIN ${TBL_PROJECT_CATEGORY} ON ${TBL_PROJECT_CATEGORY}.id = ${TBL_PROJECTS}.project_cat`
      // `LEFT JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${C_CONTACT}.state OR ${STATE_TBL}.state = ${C_CONTACT}.state)`,
      // `LEFT JOIN ${CITY_TBL} ON (${CITY_TBL}.ctid = ${C_CONTACT}.city OR ${CITY_TBL}.cname = ${C_CONTACT}.city)`
    ],
    additional: [
      // `GROUP BY ${TBL_PROJECTS}.e_id`,
      `ORDER BY ${TBL_PROJECT_CATEGORY}.priority asc`,
      // `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
    distinctCount: `${TBL_PROJECT_CATEGORY}.id`,
  };

  
  if (req.params.id>0) {
    queryMap.conditions.push(`${TBL_PROJECT_CATEGORY}.id LIKE ?`);
    queryMap.parameters.push(`%${req.params.id}%`);
  }

  

  const { result, total } = await getProjectsCategoryPaginationService(
    queryMap
  );

  return res.status(200).json({
    status: true,
    data: result,
    records: total,
  });
});


const projectCategoryField = [

  "project_name",
  "description",
  
];

const post_projectCategory = tryCatch(async (req, res) => {
  
  const queryMap = {
    attributes: [...projectCategoryField, "active"],
    parameters: [
      ...projectCategoryField.map((field) => req.body[field]),
      "Y"
    ],
  };
  
  const result = await addProjectCategory(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Failed to insert new project");
  }

  return res
    .status(200)
    .json({ success: true, message: "Category Added Successfully" });
});

 

const updateCategoryById = tryCatch(async (req, res) => {

  const { id } = req.params;
  const update  = req.body;  

  const requiredFields = {};
  [...projectCategoryField, "active"].forEach((field) => {
    if (update[field]) requiredFields[field] = update[field]; 
  });

  const { column, value } = updateColumn(requiredFields);   

  const queryMap = {
    update: [column].join(", "),
    conditions: [`${TBL_PROJECT_CATEGORY}.id = ?`],
    parameters: [...value, id]
  }
  

  
const result = await updateCategoryService(queryMap);
if(result instanceof Error){
  res.statusCode = 400;
  throw new Error("Error while updating the school")
}

return res.status(200).json({
  success: true,
  message: "Category Updated Successfully"
})


});


const deleteCategorysById = tryCatch(async (req, res) => {

  const { id } = req.params;

  const queryMap = {
    conditions: [`${TBL_PROJECT_CATEGORY}.id = ?`],
    parameters: [id]
  };

  const result = await deleteCategoryService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while Category school")
  }

  return res.status(200).json({
    success:true,
    message: "Category deleted successfully"
  })

});



const updateProjectById = tryCatch(async (req, res) => {
  

  const { id } = req.params;
  const update  = req.body;  

  

  const requiredFields = {};
  [...projectCreateField, "active"].forEach((field) => {
    if (update[field]) requiredFields[field] = update[field]; 
  });

  

  const { column, value } = updateColumn(requiredFields);   

  const queryMap = {
    update: [column].join(", "),
    conditions: [`${TBL_PROJECTS}.id = ?`],
    parameters: [...value, id]
  }
  

  

  
const result = await updateProjectService(queryMap);
if(result instanceof Error){
  res.statusCode = 400;
  throw new Error("Error while updating the Project")
}

return res.status(200).json({
  success: true,
  message: "Project Updated Successfully"
})


});



module.exports = {
  get_researchInformation,
  post_researchInformation,
  get_project_cat,
  post_projectCategory,
  updateCategoryById,
  deleteCategorysById,
  updateProjectById
};
