const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const {
  SC_USER,
  CMS_ADMIN,
  SCHOOL_DETAIL,
  C_INSTITUTE,
} = require("../../../../models/tables");
const { BUYER, SCHOOL } = require("../../../../common/constants");
const {
  checkBuyerSchoolExist,
  checkBuyerExist,
  checkLeadAlreadyExist,
  checkSchoolExist,
} = require("../../../../utils/leadAccessCheck");
const { errorMsgEmpty } = require("../../../../utils/errors_message");

const table = CMS_ADMIN;
const schoolTbl = SCHOOL_DETAIL;
const college_tbl = C_INSTITUTE;

//@desc get one school partner details
//@route GET /api/v1/admin/become-partner/:id
//@access Private ADMIN
const getpartnercollege = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id } = req.params;

  const attributes = [
    `${college_tbl}.e_id`,
    `${college_tbl}.institute_name as name`,
    `${college_tbl}.institute_url as url`,
  ];
  const schoolAttributes = [
    `${schoolTbl}.admission_partner`,
    `${schoolTbl}.school_name`,
    `${schoolTbl}.asc_reg_fee`,
    `${schoolTbl}.buyer_name`,
    `${schoolTbl}.sid`,
  ];
  const schoolSql = `SELECT ${attributes} FROM ${college_tbl} WHERE is_partner=1`;
  const schoolResult = await dbQuery(schoolSql, []);

  return res.status(200).json({
    status: true,
    data: schoolResult,
    records: schoolResult.length,
  });
});

// @desc GET ALL THE BUYERS
// @route GET /api/v1/admin/become-partner
// @access Private ADMIN
const getUsers = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];

  const attributes = [
    `${table}.id`,
    `${table}.user`,
    `${table}.password`,
    `${table}.admin_type`,
    `${table}.assign_college`,
    `${table}.active`,
  ];
  let sort = "";
  if (req.params.id) {
    sort = ` and id=${req.params.id} `;
  }

  sql = `SELECT ${attributes.join(
    ", "
  )} FROM ${table} WHERE 1=1 ${sort} ORDER BY ${table}.id DESC`;

  result = await dbQuery(sql, [BUYER]);
  if (!result.length) {
    errorMsgEmpty("No buyers found", res);
  }
  return res.status(200).json({
    status: "success",
    data: result,
  });
});

const addUser = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];

  const { id, user, password, assign_college, active } = req.body;
  if (!user || !password) {
    res.statusCode = 400;
    throw new Error("Please fill all the fields");
  }

  sql = `INSERT INTO ${table} (user, password, assign_college, active) VALUES (?,?,?,?)`;
  result = await dbQuery(sql, [user, password, assign_college, active]);
  if (!result.affectedRows) {
    throw new Error("Some Error occured while becoming a partner");
  }

  return res.status(200).json({
    success: true,
    message: "User  added successfully",
  });
});

// @desc if school partner is already exist and want new school to be added
// @route PUT /api/v1/admin/become-partner-add
// @access Private ADMIN
const addExistingBuyerToSchoolPartner = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const {
    sid, // School ID
    us_id, // Buyer ID
    asc_reg_fee, // Registration Fees
  } = req.body;

  if (!sid || !us_id || !asc_reg_fee) {
    res.statusCode = 400;
    throw new Error("Please fill all the fields");
  }

  const doesBuyerExist = await checkBuyerExist(us_id);
  if (!doesBuyerExist) throw new Error("Buyer doesn't exist");
  const doesAnotherBuyerSchoolExist = await checkBuyerSchoolExist(sid, us_id);
  if (!doesAnotherBuyerSchoolExist) {
    throw new Error("A different buyer already exist, or might not exist");
  }

  sql = `UPDATE ${schoolTbl} SET buyer_name = ?, asc_reg_fee = ? WHERE sid = ?`;
  result = await dbQuery(sql, [us_id, asc_reg_fee, sid]);

  if (!result.affectedRows) {
    throw new Error(
      "Error occured while inserting school info, please re-fill all details"
    );
  }

  return res.status(200).json({
    success: true,
    message: "New School Partner added successfully to the buyer",
  });
});

//@desc UPDATE school partner details
//@route PUT /api/v1/admin/become-partner
//@access Private ADMIN
const updateupdateUser = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id, update } = req.body;

 

  const { user, password, assign_college, active } = req.body;

  console.log("???",password)

  let setpassword=''
  if(password){
    setpassword=` password='${password}', `
  }

  sql = `UPDATE ${table} SET user=?, ${setpassword} assign_college=?, active=?  WHERE id = ?`;
  
 
  result = await dbQuery(sql, [
    user,
    assign_college,
    active,
    req.body.id,
  ]);
  if (!result.affectedRows) throw new Error("Error while update buyer details");

  return res.status(200).json({
    success: true,
    message: "Successfully updated user details",
  });
});

module.exports = {
  addUser,
  getUsers,
  addExistingBuyerToSchoolPartner,
  updateupdateUser,
  getpartnercollege,
};
