const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const jwt = require("jsonwebtoken");
const { CMS_ADMIN } = require("../../../models/tables");

const table = CMS_ADMIN;

// @desc Login Admin Dashboard
// @api  GET /api/admin/login
// @access Public
const admin_login = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { username, password } = req.body;

  
  if (!username || !password) {
    res.statusCode = 401;
    throw new Error("Enter all details");
  }

  // Check for is admin Exist
  sql = `SELECT * FROM ${table} WHERE user = ? AND password = ? LIMIT 1`;
  result = await dbQuery(sql, [username, password]);
  if (result.length === 0) {
    statusCode = 401;
    throw new Error("Invalid username or password");
  }

  const { admin_type, id } = result[0];

  return res.status(200).json({
    success: true,
    token: generateToken({ admin_type, id }),
    message: "Login Success",
  });
});

const generateToken = (admin) => {
  return jwt.sign({ admin }, process.env.JWT_SECRET, {
    expiresIn: process.env.JWT_EXPIRES_IN,
  });
};

module.exports = { admin_login };
