const tryCatch = require("../../../utils/tryCatch");
const updateColumn = require("../../../utils/updateColumn");
const { dbQuery } = require("../../../config/db.config");
const {
  SCL_STUDENT,
  SCHOOL,
} = require("../../../common/constants");

const {
  COURSE,
  CATEGORY,
  TBL_NPF_API,
  NPF_COURSE_MASTER,
  SC_USER,
  NPF_RESPONSE,
  STUDY_INDIA
} = require("../../../models/tables");
const {
  getNPFPaginationService,
  addNewCourseService,
  updateCourseService,
  deleteCourseService,
  getNPFCourseServices,
  getNPFleadsPaginationService,
  getNPFIndividualPaginationService,
} = require("../../../services/master/npf.service.js");
const { areAllKeysPresent } = require("../../../utils/common_utils");

const {
  checkLeadAlreadyExist,
  getSchoolsBasicDetails,
} = require("../../../utils/leadAccessCheck");


const axios = require("axios");
const {
  getSinglevalueByid,
  getlastinsertidforNPF,
  getotherorchidschoolbycity,
  getNPFCourse,
  NPFResponseUpdate,
  NPFResponseUpdatebytable,
} = require("../../../utils/leadAccessCheck");

// @desc get all Course details 50 limit
// @api GET /api/v1/admin/third-party-api
// @access Private

const npf_leads = tryCatch(async (req, res) => {
  const { page = 1, limit = 50, type } = req.query;
  const offset = Number((page - 1) * limit);

  
   
  

  const queryMap = {
    attributes: [`npf_response.*, tbl_npf_api.college_name`],
    // conditions: [`${NPF_RESPONSE}.active = 'Y'`],
    joinTbl: [
      `LEFT JOIN ${TBL_NPF_API} ON ${TBL_NPF_API}.eid = ${NPF_RESPONSE}.e_id`,
    ],
    parameters: [],
    additional: [
      `ORDER BY ${NPF_RESPONSE}.date desc`,
      `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
  };

  // if (type) {
  //   queryMap.conditions.push(`${NPF_RESPONSE}.inst_type LIKE ?`);
  //   queryMap.parameters.push(`%${type}%`);
  // }

  const { result, total } = await getNPFleadsPaginationService(queryMap);

  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });
});

const get_APi_list = tryCatch(async (req, res) => {
  const { page = 1, limit = 50, type } = req.query;

  //

  const queryMap = {
    attributes: [`*`],
    conditions: [`${TBL_NPF_API}.active = 'Y'`],
    parameters: [],
    additional: [`ORDER BY ${TBL_NPF_API}.id ASC`],
  };

  if (type) {
    queryMap.conditions.push(`${TBL_NPF_API}.inst_type LIKE ?`);
    queryMap.parameters.push(`%${type}%`);
  }

  const { result, total } = await getNPFPaginationService(queryMap);

  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });
});

const get_APi_Courselist = tryCatch(async (req, res) => {
  const { eid } = req.query;

  const queryMap = {
    attributes: [`*`],
    conditions: [`${NPF_COURSE_MASTER}.active = 'Y'`],
    parameters: [],
    additional: [`ORDER BY ${NPF_COURSE_MASTER}.id ASC`],
  };

  if (eid) {
    queryMap.conditions.push(`${NPF_COURSE_MASTER}.e_id = ?`);
    queryMap.parameters.push(`${eid}`);
  }

  const { result, total } = await getNPFCourseServices(queryMap);

  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });
});

// @desc post course
// @api POST /api/v1/admin/course
// @access Private ADMIN
const post_tpi = tryCatch(async (req, res) => {
  

  



  //  select sid from school_detail where  admission_partner='Y'
  //  and school_name like '%Orchid%' and city like '%".$city."%'
  //  order by rand()

  //  req.body.institute_id

  //  const sid = await getSinglevalueByid(
  //   "sid",
  //   "school_detail",
  //   "eid",
  //   req.body.institute_id
  // );

  let lastinsert = req.body.us_id ? req.body.us_id : null;

  let eids = null;
  let manipulatesource = null;

  const eid = await getSinglevalueByid(
    "eid",
    "tbl_npf_api",
    "eid",
    req.body.institute_id
  );

  if (req.body.organization == "school" && !eid.eid) {
    const oisfind = await getotherorchidschoolbycity(req.body.city);
    eids = oisfind.eid ? oisfind.eid : eid.eid;
    if (eids > 0) {
      manipulatesource = "letseduvate";
    }

    if (!eids) throw new Error("No API Exist");
  } else {
    eids = eid.eid;
  }

  if (!req.body.us_id) {
    let tablenames = [
      { table: "sc_user", value: "us_username" },
      { table: "study_india", value: "email" },
    ];

    let emailfield = tablenames.filter((d) => d.table == req.body.sourcetalbe);
    if (
      req.body.perspectivecolumn ||
      req.body.sourcetalbe ||
      emailfield ||
      req.body.email
    ) {
      let lid = (lastinsert = await getlastinsertidforNPF(
        req.body.perspectivecolumn,
        req.body.sourcetalbe,
        emailfield[0].value,
        req.body.email
      ));

      lastinsert = lid.insertid;
    }
  }

  const college_id = await getSinglevalueByid(
    "college_id",
    "tbl_npf_api",
    "eid",
    eids
  );
  const api = await getSinglevalueByid("api", "tbl_npf_api", "eid", eids);
  const secret_key = await getSinglevalueByid(
    "secret_key",
    "tbl_npf_api",
    "eid",
    eids
  );
  const source = await getSinglevalueByid("source", "tbl_npf_api", "eid", eids);

  const api_name = await getSinglevalueByid(
    "api_name",
    "tbl_npf_api",
    "eid",
    eids
  );

  // process.exit();

  const numberString = req.body.contact.toString();
  const last10Digits = numberString.slice(-10);

  let kalkahead = [];

  if (req.body.organization == "college") {
    // if (eids == "4886") {
    //   var postData = {
    //     college_id: college_id.college_id,
    //     secret_key: secret_key.secret_key,
    //     source: source.source,
    //     name: req.body.name,
    //     email: req.body.email,
    //     mobile: last10Digits,
    //     state: req.body.state,
    //     city: req.body.city,
    //     campus: req.body.campus,
    //     course: req.body.course,
    //     specialization: req.body.specialization,
    //   };
    // } else
    if (eids == "5021") {
      var postData = {
        entity: secret_key.secret_key,
        session: "2024-25 Odd",
        course: req.body.specialization,
        stream: req.body.course,
        batch: "Sem 1",
        autoApplicationNumber: true,
        allApplicationNumber: true,
        currentStage: "Lead",
        sourceId: null,
        source: source.source,
        name: req.body.name,
        phone: last10Digits,
        email: req.body.email,
        dob: null,
        fatherName: null,
        gender: null,
        address: req.body.state,
        city: req.body.city,
        state: req.body.state,
        country: "India",
        pinCode: "000000",
      };
    } else if (eids == "4886") {
      var postData = {
        fullname: req.body.name,
        email: req.body.email,
        mobile: last10Digits,
        state: req.body.state,
        city: req.body.city,
        course: req.body.course,
        specialization: req.body.specialization,
        status: "Non-Practitioner",
        neet: "-",
        father: "-",
        caste: "-",
      };
    } else if (eids == "3998") {

      var postData = [{
        "Attribute": "FirstName",
        "Value": req.body.name
    },
    {
        "Attribute": "LastName",
        "Value": "-"
    },
    {
        "Attribute": "Email",
        "Value": req.body.email
    },
    {
        "Attribute": "Phone",
        "Value": last10Digits
    },
    {
        "Attribute": "mx_Date_of_Birth",
        "Value": "-"
    },
    {
        "Attribute": "mx_FATHER_NAME",
        "Value": "-"
    },
    {
        "Attribute": "mx_Mother_Name",
        "Value": "-"
    },
    {
        "Attribute": "mx_State",
        "Value": req.body.state
    },
    {
        "Attribute": "mx_City",
        "Value": req.body.city
    },
    {
        "Attribute": "Source",
        "Value": source.source
    },
    {
        "Attribute": "SourceMedium",
        "Value": source.source
    },
    {
        "Attribute": "mx_Sub_Source",
        "Value": source.source
    },
    {
        "Attribute": "mx_Program_of_Interest",
        "Value": req.body.course
    }
    ];

    
    kalkahead = {
      headers: {
        "Content-Type": "application/json",
        Secret: "6f257cb8-6622-4d9f-bf72-45d2fff6b9a0",
      },
    };


    } else if (eids == "4960") {
      var postData = {
        fullname: req.body.name,
        email: req.body.email,
        mobile: last10Digits,
        state: req.body.state,
        city: req.body.city,
        course: req.body.course,
        father: "-",
        caste: "-",
        specialization: req.body.specialization,
        status: "Non-Practitioner",
        neet: "-",
      };
      // var postData =`{
      // "name": "Dhanyaaa",
      // "fullname": "Dhanyaaa",
      // "email": "dlalithadhanya007@gmail.com",
      // "mobile": "5283110006",
      // "state": "Uttar Pradesh",
      // "city": "Allahabad",
      // "course": "BDS",
      // "father": "-",
      // "caste": "-",
      // "specialization": "Dental Science",
      // "status": "Non-Practitioner",
      // "neet": "-"
      // }

      kalkahead = {
        headers: {
          "Content-Type": "application/json",
          Secret: "729f65270fe6caf81cc855d4ca22f4fc460c542b",
        },
      };
    } 
    
    else if(eids == "2992"){

      var postData = {
        college_id: college_id.college_id,
        secret_key: secret_key.secret_key,
        source: source.source,
        name: req.body.name,
        email: req.body.email,
        mobile: last10Digits,
        state: req.body.state,
        city: req.body.city,
        field_program: req.body.course,
        field_session:"Session 2025",
        
      }
    }
    else {
      var postData = {
        college_id: college_id.college_id,
        secret_key: secret_key.secret_key,
        source: source.source,
        name: req.body.name,
        email: req.body.email,
        mobile: last10Digits,
        state: req.body.state,
        city: req.body.city,
        campus: req.body.campus,
        course: req.body.course,
        specialization: req.body.specialization,
      };
    }
  } else {
    if (
      api_name.api_name == "letseduvate" ||
      manipulatesource == "letseduvate"
    ) {
      let gradelist = [
        { key: "Pre-Nursery", value: "35" },
        { key: "Nursery", value: "36" },
        { key: "K1", value: "37" },
        { key: "Grade 1", value: "39" },
        { key: "Grade 2", value: "40" },
        { key: "Grade 3", value: "41" },
        { key: "Grade 4", value: "42" },
        { key: "Grade 5", value: "43" },
        { key: "Grade 6", value: "44" },
        { key: "Grade 7", value: "45" },
        { key: "Grade 8", value: "46" },
        { key: "K2", value: "38" },
        { key: "Grade 9", value: "47" },
        { key: "Grade 11", value: "51" },
        { key: "Grade 10", value: "48" },
        { key: "Long Term (LT)", value: "68" },
        { key: "Grade 12", value: "52" },
        { key: "Daycare", value: "53" },
        { key: "II PUC Commerce CEBA", value: "57" },
        { key: "II PUC Commerce SEBA", value: "56" },
        { key: "I PUC Commerce SEBA", value: "55" },
        { key: "I PUC Commerce CEBA", value: "54" },
        { key: "I PU Commerce EBAS", value: "58" },
        { key: "I PU Commerce EBAC", value: "59" },
        { key: "I PU Commerce EBABM", value: "60" },
        { key: "I PU Commerce HEBA", value: "61" },
        { key: "I PU Commerce MSBA", value: "62" },
        { key: "II PU Commerce EBAS", value: "63" },
        { key: "I PU COMMERCE EMBS", value: "105" },
        { key: "II PU Commerce EBAC", value: "64" },
        { key: "II PU Commerce EBABM", value: "65" },
        { key: "II PU COMMERCE EBMS", value: "106" },
        { key: "II PU Commerce HEBA", value: "66" },
        { key: "II PU Commerce MSBA", value: "67" },
        { key: "I PU COMMERCE ABMS", value: "107" },
        { key: "II PU COMMERCE ABMS", value: "108" },
        { key: "I PU COMMERCE ABSC", value: "109" },
        { key: "II PU COMMERCE ABSC", value: "110" },
        { key: "I PU COMMERCE ABEM", value: "111" },
        { key: "II PU COMMERCE ABEM", value: "112" },
      ];

      let filtgrade = gradelist.filter((d) => d.key == req.body.grade);
      let studentgrade = null;

      if (filtgrade.length > 0) {
        studentgrade = filtgrade[0].value;
      } else {
        studentgrade = 45;
      }

      const branch = await getSinglevalueByid(
        "branch",
        "tbl_npf_api",
        "eid",
        eids ? eids : req.body.institute_id
      );

      const branchids = await getSinglevalueByid(
        "branch_id",
        "tbl_npf_api",
        "eid",
        eids
      );

      const college_name = await getSinglevalueByid(
        "college_name",
        "tbl_npf_api",
        "eid",
        eids
      );

      var postData = {
        "Access-Api-Key": secret_key.secret_key,
        lead_name: req.body.name,
        phone_no: last10Digits,
        email_id: req.body.email,
        gender: req.body.gender,
        // grade: req.body.grade,
        grade: studentgrade,
        school: college_name.college_name
          ? college_name.college_name
          : req.body.school,
        branch_name: branch.branch,
        branch_id: branchids.branch_id,
        user_id: "906885",
        academic_year: "2025-26",
        is_boarding: req.body.is_boarding == "Boarding School" ? true : false,
      };
    } else if (eids == "3301") {

   
      var postData = {
        college_id: college_id.college_id,
        secret_key: secret_key.secret_key,
        source: source.source,
        medium: "Dehradun",
        name: req.body.name,
        email: req.body.email,
        country_dial_code: "+91",
        mobile: last10Digits,
        state: req.body.state,
        city: req.body.city,
        grade: req.body.grade,
        field_class_looking_for: req.body.grade,
        field_session: "2025-2026",
      };
    } else {
      var postData = {
        college_id: college_id.college_id,
        secret_key: secret_key.secret_key,
        source: source.source,
        medium: "All Schools Colleges",
        campaign: "No campaign",
        name: req.body.name,
        email: req.body.email,
        mobile: last10Digits,
        state: req.body.state,
        city: req.body.city,
        grade: req.body.grade,
        Curriculum: "",
      };
    }
  }
  // console.log("<>sssss<<>",eids)
  // console.log("postData",postData)

  const college_name = await getSinglevalueByid(
    "college_name",
    "tbl_npf_api",
    "eid",
    eids
  );

 

  axios.post(`${api.api}`, postData, kalkahead).then((response) => {
    // sourcetalbe:sourctable,
    // perspectivecolumn:perspectivecolumn

    // console.log("response",response.data)

    const openupdate = NPFResponseUpdatebytable(
      "npf_response",
      req.body.sourcetalbe,
      req.body.perspectivecolumn,
      lastinsert,
      response.data
    );

    // const openupdate = NPFResponseUpdatebytable(
    //   "npf_response",
    //   "sc_user",
    //   "us_id",
    //   lastinsert,
    //   response.data
    // );

    const npfupdate = NPFResponseUpdate(
      postData,
      response.data,
      req.body.sourcetalbe,
      lastinsert,
      eids,
      college_name.college_name
    );


    

    if (eids == "4960") {
      return res.status(200).json({
        success: response.data.status,
        message: response.data.status_message,
      });
    } else {
      return res.status(200).json({
        success: response.data.status ? response.data.status : response.data,
        message: response.data.message ? response.data.message : response.data,
      });
    }
  });
});

const post_add_menual_student = tryCatch(async (req, res) => {
  // return res.status(200).json({
  //   success: false,
  //   message: 'shani verma',
  // });



  

 
  let [sql, result] = [null, null];
  const {
    name,
    email,
    mobile = null,
    state = null,
    city = null,
    category = null,
    course = null,
    specialization = null,
    url = null,
  } = req.body;
  if (!name || !email)
    throw new Error("Name and email required fields are missing");

  let user_type = null;
  let school_college = null;
  let grade = null;
  let gender = null;
  let newcity =null;
  let sid=null
  let school_name=null

  if (req.body.stydenttype == "college") {
    user_type = "partner";
    school_college = "college";
  } else {
    user_type = "student";
    school_college = "school";
    grade = req.body.grade;
    gender = req.body.gender;


    const cityname = await getSinglevalueByid("cname","city_tbl","ctid",city);
    newcity=cityname.cname

     sid = await getSinglevalueByid("sid","school_detail","school_url",url);
     school_name = await getSinglevalueByid("school_name","school_detail","school_url",url);
    


  }
  if (await checkLeadAlreadyExist(email, 'school')) {
    // res.statusCode = 400;
    // throw new Error("Email already exists, Please login");

    return res
    .status(200)
    .json({ success: false, message:"Email already exists" });
  }

  


  sql = `INSERT INTO ${SC_USER} (us_fname, us_username, mobile_1, state, city,url, campus, course, specialization, user_type, school_college,class,us_gender, us_create_date) VALUES (?,?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
  result = await dbQuery(sql, [
    name,
    email,
    mobile,
    state,
    newcity?newcity:city,
    url,
    category ? category.toString() : null,
    course ? course.toString() : null,
    specialization ? specialization.toString() : null,
    user_type,
    school_college,
    grade,
    gender,
  ]);

  if(result.insertId>0 && user_type=="student"){
  const cartadd=`insert into  tbl_student_cart (institute_name,institute_id,institute_type,us_id,std,date) values (?,?,?,?,?,NOW())`;
  exe = await dbQuery(cartadd, [
    school_name.school_name?school_name.school_name:null,
    sid.sid?sid.sid:null,
    'school',
    result.insertId,
    grade
  ]);

  const cartst=`insert into  tbl_school_student (us_id,full_name,gender,std,date) values (?,?,?,?,NOW())`;
  exe = await dbQuery(cartst, [result.insertId,name,gender,grade]);
}

  


  if (!result.affectedRows) throw new Error("Error! cant post partner enquiry");
  return res
    .status(200)
    .json({ success: true, message: "Lead Created successfully" });
});

// @desc update course
// @api PUT /api/v1/admin/course
// @access Private ADMIN
const update_course = tryCatch(async (req, res) => {
  const { course_id, update } = req.body;
  if (!course_id || !update) throw new Error("course_id and update required");

  update.course_url &&
    (await urlExist(
      COURSE,
      "course_id",
      "course_url",
      update.course_url,
      course_id
    ));

  const { column, value } = updateColumn(update);

  const queryMap = {
    update: column,
    conditions: [`${COURSE}.course_id = ?`],
    parameters: [...value, course_id],
  };

  const result = await updateCourseService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Error while updating the course");
  }

  return res.status(200).json({
    success: true,
    message: "Course has been updated",
  });
});

// @desc delete course
// @api DELETE /api/v1/admin/course
// @access Private ADMIN
const del_course = tryCatch(async (req, res) => {
  const { course_id } = req.body;
  if (!course_id) throw new Error("course_id required");

  const queryMap = {
    conditions: [`${COURSE}.course_id = ?`],
    parameters: [course_id],
  };

  const result = await deleteCourseService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Error while deleting the course");
  }

  return res.status(200).json({
    success: true,
    message: "Course deleted successfully",
  });
});

const getCourseAttributes = () => {
  return {
    attributes: [
      "cat_id",
      "course_name",
      "course_fullname",
      "short_name",
      "course_duration",
      "degree_type",
      "course_url",
      "show_in_dropdown",
      "show_on_home",
    ],
    requiredFields: ["cat_id", "course_name", "course_url"],
  };
};

const get_APi_list_individual = tryCatch(async (req, res) => {
  const { type, search } = req.query;

    const { tbl  } = req.params;



    
      

    let gradelist = [
      { key: "sc_user", value: "us_id",column:"us_fname" },
      { key: "study_india", value: "s_id",column:"name" },
      { key: "tbl_freely_enquiry", value: "id",column:"fullname" },
      { key: "tbl_footer_career_enq", value: "id",column:"name" },
    ];

    

    let filterkeyid = gradelist.filter((d) => d.key == tbl);


  const queryMap = {
    // attributes: [`*`],
    attributes: [`${NPF_RESPONSE}.*, ${filterkeyid[0].key}.${filterkeyid[0].column} as name`],
    joinTbl: [
      `LEFT JOIN ${filterkeyid[0].key} ON ${NPF_RESPONSE}.primary_id = ${filterkeyid[0].key}.${filterkeyid[0].value}`,
    ],
    conditions: [`${NPF_RESPONSE}.table_name = '${filterkeyid[0].key}'`,`${NPF_RESPONSE}.primary_id = ?`],
    parameters: [`${search}`],
    additional: [`ORDER BY ${NPF_RESPONSE}.id desc`],
  };

  // if (type) {
  //   queryMap.conditions.push(`${TBL_NPF_API}.inst_type LIKE ?`);
  //   queryMap.parameters.push(`%${type}%`);
  // }

  const { result, total } = await getNPFIndividualPaginationService(queryMap);

  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });
});

module.exports = {
  get_APi_list,
  get_APi_Courselist,
  post_add_menual_student,
  post_tpi,
  update_course,
  del_course,
  npf_leads,
  get_APi_list_individual,
};
