const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");

const get_table = (loc) => {
  switch (loc) {
    case "state":
      return "state_tbl";
    case "city":
      return "city_tbl";
    case "district":
      return "district_tbl";
    default:
      throw new Error("Invalid Location");
  }
};

// @desc Get Master Data Location
// @api  GET /api/admin/location/:loc
// @access Private
const get_master = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let tbl = get_table(req.params.loc);
  sql = `SELECT * FROM ${tbl}`;
  result = await dbQuery(sql);
  if (result.length > 0) {
    return res.status(200).json({
      success: true,
      data: result,
    });
  } else {
    res.statusCode = 404;
    throw new Error("No Data Found");
  }
});

module.exports = {
  get_master,
};
