const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const updateColumn = require("../../../utils/updateColumn");
const {errorMsgEmpty} = require("../../../utils/errors_message");
const { SC_FACILITIES } = require("../../../models/tables");

const table = SC_FACILITIES;

// @desc get all School Facilities
// @api GET /api/v1/admin/sc-facility
// @access Private
const get_scFacilities = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { search = "", page = 1, limit = 50 } = req.query;
  if(page < 1) throw new Error("Page must be greater than 0");
  const offset = (page - 1) * limit;
  let qry = "";
  if(search){
    qry = `AND name LIKE '%${search}%'`;
  }
  sql = `SELECT * FROM ${table} WHERE 1=1 ${qry} ORDER BY nr_priority ASC LIMIT ? OFFSET ?`;
  result = await dbQuery(sql, [Number(limit), offset]);
  if (result.length === 0) errorMsgEmpty("No data found", res);
  const records = await dbQuery(`SELECT COUNT(*) as total FROM ${table} WHERE 1=1 ${qry}`);
  return res.status(200).json({ sucess: true, data: result, records: records[0].total });
});

// @desc post new School Facility
// @api POST /api/v1/admin/sc-facility
// @access Private ADMIN
const post_scFacilities = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { facility_for, name, nr_image = "", nr_priority } = req.body;
  if (!facility_for || !name)
    throw new Error("All fields are required");
  sql = `INSERT INTO ${table}(facility_for,name,nr_image,nr_priority,date) VALUES (?,?,?,?,NOW())`;
  result = await dbQuery(sql, [
    facility_for,
    name,
    nr_image,
    (nr_priority || null),
  ]);
  if (!result.affectedRows)
    throw new Error("Error! cant Post School Facilities");
  return res
    .status(200)
    .json({ success: true, message: "School Facility Added!" });
});

// @desc update School Facility
// @api PUT /api/v1/admin/sc-facility
// @access Private ADMIN
const update_scFacilities = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id, update } = req.body;
  const { column, value } = updateColumn(update);
  sql = `UPDATE ${table} SET ${column}, nr_update_on = NOW() WHERE id = ?`;
  result = await dbQuery(sql, [...value, id]);
  if (!result.affectedRows)
    throw new Error("Error! cant update School Facilities");
  return res
    .status(200)
    .json({ success: true, message: "School Facility Updated!" });
});

// @desc delete School Facility
// @api DELETE /api/v1/admin/sc-facility
// @access Private ADMIN
const del_scFacilities = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { id } = req.body;
  sql = `DELETE FROM ${table} WHERE id = ?`;
  result = await dbQuery(sql, id);
  if (!result.affectedRows)
    throw new Error("Error! delete fetch School Facilities");
  return res
    .status(200)
    .json({ success: true, message: "School Facility Deleted!" });
});

module.exports = {
  get_scFacilities,
  post_scFacilities,
  update_scFacilities,
  del_scFacilities,
};
