const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const {
  errorMsgAuth,
  errorMsgEmpty,
} = require("../../../utils/errors_message");
const { SC_USER } = require("../../../models/tables");
const {
  checkBuyerInstituteAccess,
  getBuyerInstituteInfo,
  checkSchoolLeadBelongsToBuyer
} = require("../../../utils/leadAccessCheck");
const { SCL_STUDENT } = require("../../../common/constants");


const {
  getEnquiryPaginationService, getEnquiryService, deleteEnquiryService, updateEnquiryService,
} = require("../../../services/enquiry.service");

const admissionTbl = SC_USER;

// @desc Get all admission enquiry from leads table, we checking leads url
// @route GET /buyer/admission-enquiry/:sid
// @access Private BUYER
const getBuyerAdmissionEnquiry = tryCatch(async (req, res) => {
  const { page = 1, limit = 50, search } = req.query;
  if (Number(page) < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = (page - 1) * limit;

  const us_id=req.query.us_id
  if (!us_id) errorMsgAuth("Unauthorised Access", res);

  const { sid } = req.params;
  const doesBuyerHaveAccessToSchool = await checkBuyerInstituteAccess(us_id, sid);
  if (!doesBuyerHaveAccessToSchool)
    errorMsgAuth("Unauthorised Access, You don't have permission for this school Enquiry", res);

   
  const buyerSchoolDetails = await getBuyerInstituteInfo(us_id);
const requiredSchoolUrl = buyerSchoolDetails.find((school) => school.sid == sid).school_url;

  // console.log("queryMap",requiredSchoolUrl)
  
  const queryMap = {
    table: admissionTbl,
    attributes: [
      `CONCAT (${admissionTbl}.us_fname, ' ', IFNULL(${admissionTbl}.us_lname, '') ) as name`,
    `${admissionTbl}.us_username`,
    `${admissionTbl}.mobile_1`,
    `${admissionTbl}.class`,
    `${admissionTbl}.parent_name AS father_name`,
    `${admissionTbl}.mother_name`,
    `${admissionTbl}.state`,
    `${admissionTbl}.city`,
    `${admissionTbl}.us_create_date`,
    `${admissionTbl}.remark`,
    `${admissionTbl}.remark_cause`,
    `${admissionTbl}.remark_date`,
    `${admissionTbl}.us_id AS s_id`,
    ],
    additional: [
      `ORDER BY ${admissionTbl}.us_id DESC`,
      `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
    conditions: [],
    parameters: [],
    joinTbl: [
      // `LEFT JOIN ${table} ON ${table}.sid = ${STUDY_INDIA}.school_id`,
    ],
  };

  
  if (sid) {
    queryMap.conditions.push(`url = ?`);
    queryMap.parameters.push(requiredSchoolUrl);
  }

  if (search) {
    queryMap.conditions.push(`${admissionTbl}.us_fname LIKE ? OR ${admissionTbl}.us_username LIKE ? OR ${admissionTbl}.mobile_1 LIKE ?`);
    queryMap.parameters.push(`%${search}%`, `%${search}%`, `%${search}%`);
  }


  

  const { result, total } = await getEnquiryPaginationService(queryMap);
  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });




  // const buyerSchoolDetails = await getBuyerInstituteInfo(us_id);
  // const requiredSchoolUrl = buyerSchoolDetails.find((school) => school.sid == sid).school_url;

  // if (!requiredSchoolUrl) {
  //   throw new Error("No school found with this id");
  // }
  // sql = `SELECT ${attributes.join(", ")} FROM ${admissionTbl} WHERE url = ? AND user_type = ?`;
  // result = await dbQuery(sql, [requiredSchoolUrl, SCL_STUDENT]);

  // if (!result.length) errorMsgEmpty("No Admission Enquiry found", res);

  // return res.status(200).json({
  //   success: true,
  //   data: result,
  //   records: result.length,
  // });

});

//@desc Update admission enquiry remark
//@route PUT /buyer/admission-enquiry/:sid
//@access Private BUYER
const updateBuyerAdmissionEnquiry = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  const { sid } = req.params;
  const doesBuyerHaveAccessToSchool = await checkBuyerInstituteAccess(us_id, sid);
  if (!doesBuyerHaveAccessToSchool)
    errorMsgAuth("Unauthorised Access, You don't have permission for this school Enquiry", res);

  const { s_id, remark, remark_cause = null } = req.body;
  if (!us_id) errorMsgAuth("Unauthorised Access", res);
  if (!remark || !s_id) throw new Error("Institute id, remark and id is required");

  const doesSchoolLeadBelongsToBuyer = await checkSchoolLeadBelongsToBuyer(us_id, s_id);
  if (!doesSchoolLeadBelongsToBuyer){
    throw new Error("School lead doesn't belongs to this buyer");
  }

  const buyerSchoolDetails = await getBuyerInstituteInfo(us_id);
  const requiredSchoolUrl = buyerSchoolDetails.find((school) => school.sid == sid).school_url;

  if (!requiredSchoolUrl) {
    throw new Error("No school found with this id");
  }

  sql = `UPDATE ${admissionTbl} SET remark = ?, remark_cause = ?, remark_date = NOW() WHERE us_id = ? AND url = ? AND user_type = ?`;
  result = await dbQuery(sql, [remark, remark_cause, s_id, requiredSchoolUrl, SCL_STUDENT]);

  if (!result.affectedRows) throw new Error("Enquiry not updated");

  return res.status(200).json({
    success: true,
    message: "Enquiry updated successfully",
  });
});

module.exports = {
  getBuyerAdmissionEnquiry,
  updateBuyerAdmissionEnquiry,
}