const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const {
  errorMsgAuth,
  errorMsgEmpty,
} = require("../../../utils/errors_message");
const { STUDY_INDIA } = require("../../../models/tables");
const { checkBuyerInstituteAccess, checkGeneralLeadBelongsToBuyer } = require("../../../utils/leadAccessCheck");

const {
  getEnquiryPaginationService, getEnquiryService, deleteEnquiryService, updateEnquiryService,
} = require("../../../services/enquiry.service");



const table = STUDY_INDIA;

// @desc Get all general enquiry
// @route GET /buyer/general-enquiry/:sid
// @access Private Buyer
const getBuyerGeneralEnquiry = tryCatch(async (req, res) => {
  
  const { page = 1, limit = 50, search } = req.query;
  if (Number(page) < 1)
    throw new Error("Page number is required and should be greater than 0");
  const offset = (page - 1) * limit;
  
  
  const us_id=req.query.us_id

  if (!us_id ) errorMsgAuth("Unauthorised Access", res);
  const { sid } = req.params;
  
  const doesBuyerHaveAccessToSchool = await checkBuyerInstituteAccess(us_id, sid);
  if(!doesBuyerHaveAccessToSchool) errorMsgAuth("Unauthorised Access, You don't have permission for this school Enquiry", res);
  // const attributes = [
  //   `${table}.s_id`,
  //   `${table}.name`,
  //   `${table}.email`,
  //   `${table}.parent_name`,
  //   `${table}.mobile`,
  //   `${table}.user_query`,
  //   `${table}.query_type`,
  //   `${table}.school_grade`,
  //   `${table}.post_date`,
  //   `${table}.remark`,
  //   `${table}.child_dob`,
  // ];

  // sql = `SELECT ${attributes.join(", ")} FROM ${table} WHERE school_id = ?`;
  // result = await dbQuery(sql, [sid]);
  // if (result.length === 0) errorMsgEmpty("No general enquiry found", res);  
  // total = await dbQuery(`SELECT count(*) as records FROM ${table} WHERE school_id = ?`, [sid]);
 
  // console.log("total",total[0].records)

  // res.status(200).json({
  //   success: true,
  //   data: result,
  //   records: total[0].records,
  // });



  const queryMap = {
    table: STUDY_INDIA,
    attributes: [
       `${table}.s_id`,
    `${table}.name`,
    `${table}.email`,
    `${table}.parent_name`,
    `${table}.mobile`,
    `${table}.user_query`,
    `${table}.query_type`,
    `${table}.school_grade`,
    `${table}.post_date`,
    `${table}.remark`,
    `${table}.budget`,
    `${table}.child_dob`,
    `${table}.current_location`,
    ],
    additional: [
      `ORDER BY ${STUDY_INDIA}.s_id DESC`,
      `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
    ],
    conditions: [],
    parameters: [],
    joinTbl: [
      // `LEFT JOIN ${table} ON ${table}.sid = ${STUDY_INDIA}.school_id`,
    ],
  };


  if (sid) {
    queryMap.conditions.push(`school_id = ?`);
    queryMap.parameters.push(sid);
  }

  if (search) {
    queryMap.conditions.push(`${table}.name LIKE ? OR ${table}.email LIKE ? OR ${table}.mobile LIKE ?`);
    queryMap.parameters.push(`%${search}%`, `%${search}%`, `%${search}%`);
  }

  

  const { result, total } = await getEnquiryPaginationService(queryMap);
  return res.status(200).json({
    success: true,
    data: result,
    records: total,
  });


});

// @desc Update general enquiry
// @route PUT /buyer/general-enquiry/:sid
// @access Private Buyer
const updateBuyerGeneralEnquiry = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  const { sid } = req.params;
  const doesBuyerHaveAccessToSchool = await checkBuyerInstituteAccess(us_id, sid);
  if(!doesBuyerHaveAccessToSchool) errorMsgAuth("Unauthorised Access, You don't have permission for this school Enquiry", res);
  const { s_id, remark, remark_cause } = req.body;
  if (!us_id) errorMsgAuth("Unauthorised Access", res);
  if (!remark || !remark_cause || !s_id) throw new Error("Institute id, remark and id is required");
  const doesGeneralLeadBelongsToBuyer = await checkGeneralLeadBelongsToBuyer(us_id, s_id);
  if(!doesGeneralLeadBelongsToBuyer) errorMsgAuth("Unauthorised Access, You don't have permission for this Lead", res);
  sql = `UPDATE ${table} SET remark = ?, remark_cause = ? WHERE s_id = ? AND school_id = ?`;
  result = await dbQuery(sql, [remark, remark_cause, s_id, sid]);
  if (result.affectedRows === 0) throw new Error("Enquiry not updated");
  res.status(200).json({
    success: true,
    message: "Enquiry updated successfully",
  });
});

module.exports = {
  getBuyerGeneralEnquiry,
  updateBuyerGeneralEnquiry,
};
