const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const {
  errorMsgEmpty,
  errorMsgAuth,
} = require("../../../utils/errors_message");
const { SC_USER } = require("../../../models/tables");
const generateToken = require("../../../utils/jwtGenerate");
const { BUYER } = require("../../../common/constants");
const { getSinglevalueByid }  = require("../../../utils/leadAccessCheck")

// @desc    Post Login details of buyer
// @route   POST /api/v1/open/buyer-login
// @access  Public Buyer
const postBuyerLogin = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { email, password, institute_type } = req.body;
  if (!email || !password || !institute_type) {
    res.statusCode = 401;
    throw new Error("Enter all details");
  }

  const isCollegeBuyer = institute_type === "college" ? 1 : 0;

  // Check for is buyer Exist
  sql = `SELECT user_type, us_id FROM ${SC_USER} WHERE (email_1 = ? OR us_username = ?) AND us_password = ? AND user_type = ? LIMIT 1`;
  result = await dbQuery(sql, [email, email, password, BUYER]);

  if (result.length === 0) {
    res.statusCode = 401;
    throw new Error("Invalid email or password");
  }

  
  

  const { user_type, us_id } = result[0];

  const schoold = await getSinglevalueByid("sid","school_detail","buyer_name",us_id);
  let sid=schoold.sid

  res.status(200).json({
    success: true,
    auth_token: generateToken({ user_type, us_id, sid }),
  });
});

module.exports = { postBuyerLogin };
