const { C_INSTITUTE, SCHOOL_DETAIL, SC_USER, BUYER_ORDER_DETAILS } = require("../../../models/tables");
const { getCollegeService } = require("../../../services/college.service");
const { getSchoolDetailsService } = require("../../../services/school.service");
const { updateScUserService } = require("../../../services/sc_user.service");
const { addNewBuyerOrderService } = require("../../../services/buyer_order.service");
const tryCatch = require("../../../utils/tryCatch");
const { dbQuery } = require("../../../config/db.config");
// const razorpay = require("./razorpay");
const short = require("short-uuid");

// @desc   POST order for razorpay
// @route  POST /api/v1/payment/order
// @access Public
const postOrder = tryCatch(async (req, res) => {

  const { feesType, instituteId, instituteType } = req.body;
  if (!feesType) throw new Error("no fees_type given");
  if (!instituteId) throw new Error("no institute_id given");
  if (!instituteType) throw new Error("no institute_type given");

  const feeToBePaidByUser = await generateFeesForUser(feesType, instituteId, instituteType);
  
  const receipt = short.generate();

  const options = {
    amount: feeToBePaidByUser,
    currency: "INR",
    receipt: receipt,
  };

  try {
    const response = await razorpay.orders.create(options);
    return res
      .status(200)
      .json({
        success: true,
        message: "order added!",
        orderId: response.id,
        currency: response.currency,
        amount: response.amount,
      });
  } catch (err) {
    console.log("post_order", err);
    return res
      .status(400)
      .json({ success: false, message: "error while creating order" });
  }

});

/**
 * @desc update user on order success
 * @route POST /api/v1/student/payment-success
 * @access Private  
*/
const paytmsuccess = tryCatch(async (req, res) => {
 
  

  let [sql , result] = [null, null];
  const { id } = req.params;
 
  const attributes = [
    `${BUYER_ORDER_DETAILS}.BUYER_ID`,
    `${BUYER_ORDER_DETAILS}.PAYMENT_SOURCE`,
    `${BUYER_ORDER_DETAILS}.AMOUNT`,

    `${BUYER_ORDER_DETAILS}.TXNID`,
    `${BUYER_ORDER_DETAILS}.BANKTXNID`,
    `${BUYER_ORDER_DETAILS}.ORDERID`,
    `${BUYER_ORDER_DETAILS}.TXNAMOUNT`,
    `${BUYER_ORDER_DETAILS}.STATUS`,
  ];
  
  const getpayment = `SELECT ${attributes} FROM ${BUYER_ORDER_DETAILS} WHERE BUYER_ID=? and STATUS='TXN_SUCCESS'`;
  const paymentresult = await dbQuery(getpayment, [id]);

  console.log("paymentresult",paymentresult)
   

 

  return res.status(200).json({
    status: true,
    data: paymentresult,
    records: paymentresult.length,
  });

});

module.exports = {
  postOrder,
  paytmsuccess,
};

const generateFeesForUser = async (feesType, instituteId, instituteType) => {
  try {

    const query = {};
    let callToDb = undefined;

    switch (instituteType) {
      case "college":
        query.attributes = [`${C_INSTITUTE}.application_fee AS fee`];
        query.conditions = [`${C_INSTITUTE}.e_id = ${instituteId}`];
        query.additional = [`LIMIT 1`];
        callToDb = getCollegeService;
        break;
      
      case "school":
        query.attributes = [`${SCHOOL_DETAIL}.application_fees AS fee`];
        query.conditions = [`${SCHOOL_DETAIL}.s_id = ${instituteId}`];
        query.additional = [`LIMIT 1`];
        callToDb = getSchoolDetailsService;
      default:
        break;
    }

    const result = await callToDb(query);
    if(!result instanceof Error || !result[0]){
      return 0;
    };

    return result[0].fee;

  } catch (error) {
    throw new Error(error)
  }
};