const { C_INSTITUTE, SCHOOL_DETAIL, SC_USER, BUYER_ORDER_DETAILS } = require("../../models/tables");
const { getCollegeService } = require("../../services/college.service");
const { getSchoolDetailsService } = require("../../services/school.service");
const { updateScUserService } = require("../../services/sc_user.service");
const { addNewBuyerOrderService } = require("../../services/buyer_order.service");
const tryCatch = require("../../utils/tryCatch");
const razorpay = require("./razorpay");
const short = require("short-uuid");

// @desc   POST order for razorpay
// @route  POST /api/v1/payment/order
// @access Public
const postOrder = tryCatch(async (req, res) => {

  const { feesType, instituteId, instituteType } = req.body;
  if (!feesType) throw new Error("no fees_type given");
  if (!instituteId) throw new Error("no institute_id given");
  if (!instituteType) throw new Error("no institute_type given");

  const feeToBePaidByUser = await generateFeesForUser(feesType, instituteId, instituteType);
  
  const receipt = short.generate();

  const options = {
    amount: feeToBePaidByUser,
    currency: "INR",
    receipt: receipt,
  };

  try {
    const response = await razorpay.orders.create(options);
    return res
      .status(200)
      .json({
        success: true,
        message: "order added!",
        orderId: response.id,
        currency: response.currency,
        amount: response.amount,
      });
  } catch (err) {
    console.log("post_order", err);
    return res
      .status(400)
      .json({ success: false, message: "error while creating order" });
  }

});

/**
 * @desc update user on order success
 * @route POST /api/v1/student/payment-success
 * @access Private  
*/
const paymentSuccess = tryCatch(async (req, res) => {
  const { us_id, user_type } = req.lead;
  if (!us_id || !user_type) {
    res.statusCode = 400;
    throw new Error("Unauthorized access");
  }
  const { razorpay_order_id, razorpay_payment_id, feesType, amount } = req.body;
  if (!razorpay_order_id || !razorpay_payment_id) {
    res.statusCode = 400;
    throw new Error("razorpay_order_id, razorpay_payment_id not found");
  }
  if (!feesType || !amount) {
    res.statusCode = 400;
    throw new Error("feesType or amount not found");
  }

  const queryMap = {
    update: [`order_id = '${razorpay_order_id}'`, `us_update_date = NOW()`, `payment_status = 'success'`, `erp = '${feesType}'`].join(", "),
    conditions: [`${SC_USER}.us_id = ?`, `${SC_USER}.user_type = ?`],
    parameters: [us_id, user_type],
  };

  const buyerQueryMap = {
    attributes: ["BUYER_ID", "PAYMENT_SOURCE", "AMOUNT", "ORDERID", "GATEWAYNAME", "TXNDATE", "PAY_FOR", "PACKAGE_NAME"],
    parameters: [us_id, `Partner Student ${feesType} fee`, amount, razorpay_order_id, "RAZORPAY", new Date(), feesType, ""],
  }

  const buyerResult = await addNewBuyerOrderService(buyerQueryMap);
  if (buyerResult instanceof Error) {
    res.statusCode = 400;
    throw new Error("Error while adding buyer order");
  }

  const result = await updateScUserService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 400;
    throw new Error("Error while updating user data");
  }

  return res.status(200).json({
    success: true,
    message: "payment success, We will contact you soon!",
  });
});

module.exports = {
  postOrder,
  paymentSuccess,
};

const generateFeesForUser = async (feesType, instituteId, instituteType) => {
  try {

    const query = {};
    let callToDb = undefined;

    switch (instituteType) {
      case "college":
        query.attributes = [`${C_INSTITUTE}.application_fee AS fee`];
        query.conditions = [`${C_INSTITUTE}.e_id = ${instituteId}`];
        query.additional = [`LIMIT 1`];
        callToDb = getCollegeService;
        break;
      
      case "school":
        query.attributes = [`${SCHOOL_DETAIL}.application_fees AS fee`];
        query.conditions = [`${SCHOOL_DETAIL}.s_id = ${instituteId}`];
        query.additional = [`LIMIT 1`];
        callToDb = getSchoolDetailsService;
      default:
        break;
    }

    const result = await callToDb(query);
    if(!result instanceof Error || !result[0]){
      return 0;
    };

    return result[0].fee;

  } catch (error) {
    throw new Error(error)
  }
};