const {
  validateWebhookSignature,
} = require("razorpay/dist/utils/razorpay-utils");
const {
  transporter,
  mailSentCallback,
} = require("../admin/CMS/EmailTemplate/send_email.controller");
const { SC_USER } = require("../../models/tables");

const handleRazorpayEvents = async (req, res) => {
  try {
    const eventTypes = {
      PAYMENT_FAILED: "payment.failed",
      PAYMENT_CAPTURED: "payment.captured",
    };

    const receivedEvent = req.body.event;
    const isUnknownEvent = !Object.values(eventTypes).includes(receivedEvent);
    if (isUnknownEvent) {
      return res.status(400).send({ message: "Unknown event" });
    }

    const { WEBHOOK_SECRET, EMAIL_FROM } = process.env;

    const secret = WEBHOOK_SECRET;
    const razorpaySignature = req.headers["x-razorpay-signature"];
    const isValidSignature = validateWebhookSignature(
      JSON.stringify(req.body),
      razorpaySignature,
      secret
    );

    if (!isValidSignature) {
      return res.status(400).json({
        message: "Invalid signature",
      });
    }

    res.status(200).json({ status: "ok" }); // Razorpay expects a 2xx response within 5 seconds

    const razorpayEventId = req.headers["x-razorpay-event-id"];
    let { amount, contact } = req.body.payload.payment.entity;
    amount = Number(amount) / 100; // converting paise to rupee

    // const paymentAlertMail = {
    //   from: EMAIL_FROM,
    //   to: email,
    //   subject: "Payment received",
    //   html: `<p>Payment amount INR ${amount} received from phone: ${contact}</p>`,
    // };

    // if (receivedEvent === eventTypes.PAYMENT_FAILED) {
    //   console.log(`Razorpay event id: ${razorpayEventId}\nPayment of INR ${amount}, failed for lead with phone: ${contact}`);
    //   paymentAlertMail["subject"] = "Payment failed";
    //   paymentAlertMail["html"] = `<p>Payment of INR ${amount}\n, failed for lead with email: ${email} and phone: ${contact}</p>`;
    //   return;
    // }

    // console.log(`Razorpay event id: ${razorpayEventId}\nPayment amount INR ${amount} received from phone: ${contact}`);

    // transporter.sendMail({
    //   ...paymentAlertMail,
    //   to:'jaryalshaurya2203@gmail.com', // EMAIL_FROM <-- CAN BE CHANGED to admin email
    // }, mailSentCallback);

    return;
  } catch (err) {
    console.log(err);
    return res.status(500).json({
      code: "INTERNAL SERVER ERROR",
      message: `An internal error took place. \n ${err.message}`,
    });
  }
};

module.exports = handleRazorpayEvents;
