const {
  getCareerOpportunitiesService,
} = require("../../../services/career.service");
const { getCategoryService } = require("../../../services/category.service");
const {
  CAREER_LIST,
  CATEGORY,
  COURSE,
  SPECIALIZATION,
} = require("../../../models/tables");
const tryCatch = require("../../../utils/tryCatch");

// @desc get career category for public display
// @route GET /api/v1/public/career-opportunities/category
// @access PUBLIC
const getCareerCategory = tryCatch(async (req, res) => {
  const queryMap = {};
  queryMap.attributes = [
    `${CATEGORY}.cat_id`,
    `${CATEGORY}.cat_name AS name`,
    `${CATEGORY}.cat_url AS url`,
  ];
  queryMap.conditions = [
    `${CATEGORY}.active = 'Y'`,
    `${CATEGORY}.iscareer = 'Y'`,
  ];
  queryMap.additional = [`ORDER BY ${CATEGORY}.priority ASC`];

  const result = await getCategoryService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 404;
    throw result;
  }

  return res.status(200).json({
    success: true,
    data: result,
  });
});

// @desc get one career details for public display
// @route GET /api/v1/public/career-opportunity/:url
// @access PUBLIC
const getOneCareerDetails = tryCatch(async (req, res) => {
  const { url } = req.params;

  const queryMap = {};
  queryMap.attributes = [`${CAREER_LIST}.*`];
  queryMap.conditions = [
    `${CAREER_LIST}.career_url = '${url}'`,
    `${CAREER_LIST}.active = 'Y'`,
    // `${CAREER_LIST}.show_on_home = 'Y'`, /// Commented by shani
  ];

 

  const result = await getCareerOpportunitiesService(queryMap);
  if (result instanceof Error || result.length === 0) {
    res.statusCode = 404;
    throw new Error("No data found");
  }

  return res.status(200).json({
    success: true,
    data: result.pop(),
  });
});

// @desc get all career course for public display
// @route GET /api/v1/public/career-opportunities?search=category-url
// @access PUBLIC
const getCareerOpportunities = tryCatch(async (req, res) => {

  const { search } = req.query;
  // const queryMap = {};
  const queryMap = {  additional: [`LIMIT 0, 60`],}; /// shani
  queryMap.attributes = [
    `${CAREER_LIST}.content_id`,
    `${CAREER_LIST}.career_name`,
    `${CAREER_LIST}.career_url`,
    `${CAREER_LIST}.career_logo`,
    `${CAREER_LIST}.career_details_image`,
    `${CAREER_LIST}.small_content`,
    `${CAREER_LIST}.early_salary_start`,
    `${CAREER_LIST}.early_salary_end`,
    `${CAREER_LIST}.midlevel_salary_start`,
    `${CAREER_LIST}.midlevel_salary_end`,
    `${CAREER_LIST}.seniorlevel_salary_start`,
    `${CAREER_LIST}.seniorlevel_salary_end`,
    `${CATEGORY}.cat_name`,
    `${COURSE}.course_name`,
    `${SPECIALIZATION}.spce_name`,
  ];
  queryMap.conditions = [
    // `${CAREER_LIST}.show_on_home = 'Y'`,  /// shani
    // `${CAREER_LIST}.show_on_home = 'Y' or ${CAREER_LIST}.show_on_home='N' `, /// shani
    `${CAREER_LIST}.active = 'Y'`,
  ];
  queryMap.joinTbl = [
    `LEFT JOIN ${CATEGORY} ON ${CATEGORY}.cat_id = ${CAREER_LIST}.category`,
    `LEFT JOIN ${COURSE} ON ${COURSE}.course_id = ${CAREER_LIST}.courseid`,
    `LEFT JOIN ${SPECIALIZATION} ON ${SPECIALIZATION}.spec_id = ${CAREER_LIST}.specialization`,
  ];

  // Search by category url and include category text
  if(search){
   // get category from category url in search
   const categoryIdFromUrl = await getCategoryService({
      attributes: [`${CATEGORY}.cat_id`, `${CATEGORY}.category_text AS description`],
      conditions: [`${CATEGORY}.cat_url = ?`, `${CATEGORY}.active = 'Y'`, `${CATEGORY}.iscareer = 'Y'`],
      parameters: [search],
      additional: [`LIMIT 1`],
   });
   const categoryId = categoryIdFromUrl.pop();
   if(!categoryId){
     res.statusCode = 404;
     throw new Error("Category not found");
   }
    queryMap.conditions.push(`${CAREER_LIST}.category = ${categoryId.cat_id}`);
    queryMap.categoryDescription = categoryId.description;
  }

  const result = await getCareerOpportunitiesService(queryMap);
  if (result instanceof Error) {
    res.statusCode = 200;
    throw result;
  }

  return res.status(200).json({
    success: true,
    data: result,
    categoryDescription: queryMap.categoryDescription,
  });
});



const getCareerSearchForPublic = tryCatch(async (req, res) => {
console.log("HI shamnj")
  
  const { search } = req.query;
  if (!search) {
    return res.status(400).json({
      success: false,
      message: "Please provide search query",
    });
  }

  const queryMap = {
    attributes :[
    `${CAREER_LIST}.career_name as name`,
    `${CAREER_LIST}.career_url as url`,
    
      
    ],
    conditions : [`${CAREER_LIST}.career_name LIKE ?`],
    parameters : [`%${search}%`],
  };
  
  const result = await getCareerOpportunitiesService(queryMap);
  if (result instanceof Error) {
    return res.status(400).json({
      success: false,
      message: "No data found",
    });
  }
  
  return res.status(200).json({
    success: true,
    data: result,
  });
});

module.exports = {
  getCareerOpportunities,
  getOneCareerDetails,
  getCareerCategory,
  getCareerSearchForPublic
};
