const { dbQuery } = require("../../../config/db.config");
const {
  C_COURSE,
  C_INSTITUTE,
  C_CONTACT,
  C_CONTENT,
} = require("../../../models/tables");
const tryCatch = require("../../../utils/tryCatch");

const clgTable = C_INSTITUTE;
const clgCourse = C_COURSE;
const clgContact = C_CONTACT;
const clgContent = C_CONTENT;

// @desc get all colleges for listing public
// @route GET /api/v1/public/colleges
// @access PUBLIC
const getCollegesForListing = tryCatch(async (req, res) => {
  const attributes = [
    `${clgTable}.e_id`,
    `${clgTable}.institute_name`,
    `${clgTable}.institute_url`,
    `${clgTable}.establish`,
    `${clgTable}.colvcnt`,
    // `${clgTable}.website`,
    `${clgTable}.facilities`,
    `${clgTable}.institute_logo`,
    `${clgTable}.institute_mainimg`,
    `${clgContact}.city`,
    `${clgContact}.state`,
    `${clgTable}.is_partner`,
  ].join(", ");

  const joinFrom = [
    `${clgTable}`,
    `${clgContact}`,
    `${clgCourse}`,
  ].join(", ");

  const joinOn = [
    `${clgTable}.e_id = ${clgContact}.e_id`,
    `${clgTable}.e_id = ${clgCourse}.e_id`,
  ].join(" AND ");

  const qry = [];

  const courseCategory = req.query.course_category;
  if(courseCategory) {
    qry.push(`course_category LIKE '%${courseCategory}%'`);
  }

  const courseNameFilter = req.query.course_namefilter;
  if(courseNameFilter) {
    if(courseNameFilter.includes("/")) {
      const coTempArr = courseNameFilter.split("/");
      const co1 = coTempArr[0];
      const co2 = coTempArr[1];
      qry.push(`(course_name LIKE '%${co1}%' OR course_name LIKE '%${co2}%')`);
    } else {
      qry.push(`course_name LIKE '%${courseNameFilter}%'`);
    }
  }

  const spceName = req.query.spce_name;
  if(spceName) {
    qry.push(`spce_name LIKE '%${spceName}%'`);
  }

  const state = req.query.state;
  if(state) {
    qry.push(`state LIKE '%${state}%'`);
  }

  const city = req.query.city;
  if(city) {
    qry.push(`city LIKE '%${city}%'`);
  }

  const courseDelivery = req.query.course_delivery;
  if(courseDelivery) {
    qry.push(`course_delivery LIKE '%${courseDelivery}%'`);
  }

  const collegeType = req.query.college_type;
  if(collegeType) {
    qry.push(`college_type LIKE '%${collegeType}%'`);
  }

  const courseLevel = req.query.course_level;
  if(courseLevel) {
    qry.push(`course_level LIKE '%${courseLevel}%'`);
  }

  const combineConditions = joinOn + (qry.length > 0 ? ( 'AND' + qry.join(" AND ") ) : '')  + " AND " + `active = 'Y'`;

  const sql = `SELECT DISTINCT ` + attributes + ` FROM ${joinFrom} WHERE 1=1 AND ${combineConditions} ORDER BY ${clgTable}.is_partner DESC LIMIT 10 OFFSET 0`;
  const result = await dbQuery(sql);

  console.log("THISIS IS SQL",sql)
  return res.status(200).json({
    success: true,
    data: result,
  });

});

module.exports = { getCollegesForListing };

// const sel_colleges = "select distinct engineering_institute.e_id,institute_name,institute_url,establish,colvcnt,website,facilities,institute_logo,institute_mainimg,city,state,is_partner from engineering_institute,engineering_institute_contact,engineering_institute_course where engineering_institute.e_id=engineering_institute_contact.e_id and engineering_institute_contact.e_id=engineering_institute_course.e_id AND active='Y' ";
// let conditions = [];

// const course_category = req.query.course_category;
// if(course_category) {
//   conditions.push(`course_category LIKE '${course_category}'`);
// }

// const course_namefilter = req.query.course_namefilter;
// if(course_namefilter) {
//   if(course_namefilter.includes("/")) {
//     const cotemparr = course_namefilter.split("/");
//     const co1 = cotemparr[0];
//     const co2 = cotemparr[1];
//     conditions.push(`(course_name LIKE '%${co1}%' OR course_name LIKE '%${co2}%')`);
//   } else {
//     conditions.push(`course_name LIKE '%${course_namefilter}%'`);
//   }
// }

// const spce_name = req.query.spce_name;
// if(spce_name) {
//   conditions.push(`specialization LIKE '%${spce_name}%'`);
// }

// const state = req.query.state;
// if(state) {
//   conditions.push(`state LIKE '${state}'`);
// }

// const city = req.query.city;
// if(city) {
//   conditions.push(`city LIKE '${city}'`);
// }

// const course_delivery = req.query.course_delivery;
// if(course_delivery) {
//   conditions.push(`mode_learning LIKE '%${course_delivery}%'`);
// }

// const duration = req.query.duration;
// const duration_type = req.query.duration_type;
// if(duration && duration_type) {
//   conditions.push(`duration ='${duration}' AND duration_type LIKE '%${duration_type}%'`);
// }

// const cost_of_study = req.query.cost_of_study;
// if(cost_of_study) {
//   //conditions.push(`course_fee LIKE '${cost_of_study}'`);
// }

// const college_type = req.query.college_type;
// if(college_type) {
//   conditions.push(`college_type LIKE '%${college_type}%'`);
// }

// const courselevel = req.query.courselevel;
// if(courselevel) {
//   conditions.push(`course_level LIKE '%${courselevel}%'`);
// }

// if(conditions.length > 0) {
//   sel_colleges += " AND " + conditions.join(" AND ");
// }

// sel_colleges += " order by is_partner desc LIMIT 0,20 ";

// connection.connect();

// connection.query(sel_colleges, function(error, results, fields) {
//   if (error) throw error;
// });

// connection.end();
