const { dbQuery } = require("../../../config/db.config");
const {
  C_COURSE,
  C_INSTITUTE,
  C_CONTACT,
  C_CONTENT,
  STATE_TBL,
  CITY_TBL,
  INSTITUTE_TYPE,
  TBL_AWARDS,
  COURSELEVEL,
  COURSE_DELIVERY,
  SPECIALIZATION,
  COMPANY_PLACEMENT,
  C_ADDITIONAL,
  COURSE,
  CATEGORY,
  NPF_COURSE_MASTER,
  TBL_NPF_API,
} = require("../../../models/tables");
const { sanitizedUrlFromParams } = require("../../../utils/sanitizedUrl");
const {
  getCollegeService,
  getCollegesContentService,
  getCollegesCourseService,
  getCollegeAwardService,
  getnpfCourses,
  getnpfCredentials,
} = require("../../../services/college.service");
const {
  getCompanyPlacementPaginationService,
} = require("../../../services/master/companyPlacement.service");
const tryCatch = require("../../../utils/tryCatch");

const { getCollegeIdBasedOnUrl } = require("../../../utils/leadAccessCheck");

// @desc get details on multiple college based on url category, its for public to view
// @route GET /api/v1/public/colleges/?url=college-url
// @access PUBLIC
const getCollegesSearchForPublics = tryCatch(async (req, res) => {
  console.log(req.params, req.query)
  const { url, course } = req.params;
  const { limit = 0, offset = 20 } = req.query;

  if (!url) {
    return res.status(404).json({
      status: "fail",
      message: "Listing not found",
      data: [],
    });
  }

  // Get Content for those required colleges list based on URL
  const queryMapCollegeContent = {
    attributes: [`${C_CONTENT}.brief_desc`, `${C_CONTENT}.full_desc`],
    conditions: [`${C_CONTENT}.on_url LIKE ?`, `${C_CONTENT}.is_active = "Y"`],
    additional: [`LIMIT 1`],
    parameters: [`%/${url}`],
  };

  const contentData = await getCollegesContentService(queryMapCollegeContent);
  // let { location, category } = sanitizedUrlFromParams(course);

  


   
  
  // Get colleges list based on URL category
  // Join college details, course details, location details, college content
  const queryMapCollege = {
    attributes: [
      `${C_INSTITUTE}.e_id`,
      `${C_INSTITUTE}.institute_name AS name`,
      `${C_INSTITUTE}.establish`,
      `${C_INSTITUTE}.institute_logo AS logo`,
      `${C_INSTITUTE}.institute_mainimg AS mainImg`,
      `${C_INSTITUTE}.is_partner`,
      `${C_INSTITUTE}.institute_name`,
      `${C_INSTITUTE}.priority`,
      `${C_CONTACT}.state`,
      `${C_CONTACT}.city`,
    ],
    conditions: [
      `${C_INSTITUTE}.active = 'Y'`,
      `(${C_COURSE}.course_category LIKE ? OR ${C_COURSE}.course_name LIKE ?)`,
    ],
    parameters: [
      ...[
        //`%${url}%`,
        `%${url.replace(/-/g, ' ')}%`,
      ],
    ],
    additional: [
      `GROUP BY ${C_INSTITUTE}.e_id`,
      `ORDER BY ${C_INSTITUTE}.is_partner DESC, ${C_INSTITUTE}.priority ASC`,
      `LIMIT 0, ${Number(offset)}`,
    ],
    joinTbl: [
      `INNER JOIN ${C_COURSE} ON ${C_INSTITUTE}.e_id = ${C_COURSE}.e_id`,
      `INNER JOIN ${C_CONTACT} ON ${C_CONTACT}.e_id = ${C_COURSE}.e_id`,
    ],
  };

  
  

  const sendData = {};
  sendData.page_description = contentData[0] || null;
  

  return res.status(200).json({
    status: "success",
    data: sendData,
  });
});

// @desc search for college name and get name and url for public to view limited to 10
// @route GET /api/v1/public/find/colleges?search=college-name
// @access PUBLIC
const  GetCustomLandingPageContent = tryCatch(async (req, res) => {
  const  search  = req.params.url;
  if (!search) {
    return res.status(400).json({
      status: "fail",
      message: "Please provide search query",
    });
  }

  const e_id = await getCollegeIdBasedOnUrl(search);
  if (!e_id) {
    return res.status(404).json({
      status: "fail",
      message: "College not found",
      data: [],
    });
  }

  
  
  const queryMap = {
    attributes: [
      `${C_INSTITUTE}.e_id`,
      `${C_INSTITUTE}.institute_name`,
      `${C_INSTITUTE}.institute_url`,
      `${C_INSTITUTE}.approved_by`,
      `${C_INSTITUTE}.institute_logo`,
      `${C_INSTITUTE}.pageTitle`,
      `${C_INSTITUTE}.metaDescription`,
      `${C_INSTITUTE}.metaKeywords`,
      `${C_INSTITUTE}.placement_company_list`,
      `${C_CONTACT}.address`,
      `${C_CONTACT}.city`,
      `${C_CONTACT}.country`,
      `${C_CONTACT}.state`,
      `${C_ADDITIONAL}.about_institute`,
      `${C_INSTITUTE}.boy_h_1 AS boy_single_seater`,
      `${C_INSTITUTE}.boy_h_2 AS boy_double_seater`,
      `${C_INSTITUTE}.boy_h_3 AS boy_triple_seater`,
      `${C_INSTITUTE}.girl_h_1 AS girl_single_seater`,
      `${C_INSTITUTE}.girl_h_2 AS girl_double_seater`,
      `${C_INSTITUTE}.girl_h_3 AS girl_triple_seater`,
      
    ],
    conditions: [`${C_INSTITUTE}.institute_url LIKE ?`],
    parameters: [`%${search}%`],
    additional: [`LIMIT 1`],
    joinTbl: [
      `INNER JOIN ${C_CONTACT} ON ${C_CONTACT}.e_id = ${C_INSTITUTE}.e_id`,
      `INNER JOIN ${C_ADDITIONAL} ON ${C_ADDITIONAL}.e_id = ${C_INSTITUTE}.e_id`,
    ],
  };

  const result = await getCollegeService(queryMap);



const { courses, pgCourses } = await setCollegeCourses(e_id);
  result.push({"course":courses});
const awardlist = await setCollegeAwards(e_id) || [];
  result.push({"awards":awardlist});
const placementCompany = await getPlacementCompany(result[0].placement_company_list);
  result.push({"placementcompany":placementCompany});


const npfdeal = await searchingnpf(e_id) || [];
result.push(npfdeal);


// console.log("npfdeal",npfdeal)




  return res.status(200).json({
    status: "success",
    data: result,
  });
});






const searchingnpf = async (e_id) => {

  
   
  try {
   
    const queryfornpfAPI = {
      attributes: [`${TBL_NPF_API}.eid`, `${TBL_NPF_API}.college_id`, `${TBL_NPF_API}.api`, `${TBL_NPF_API}.secret_key`, `${TBL_NPF_API}.source`, `${TBL_NPF_API}.api_name`],
      conditions: [`${TBL_NPF_API}.eid = ?`, `${TBL_NPF_API}.active = 'Y'`],
      parameters: [e_id],
    };
    const npfcred = await getnpfCredentials(queryfornpfAPI);


    if(npfcred.length>0){

      const queryFornpfCOurse = {
        attributes: [`${NPF_COURSE_MASTER}.e_id`, `${NPF_COURSE_MASTER}.campus`, `${NPF_COURSE_MASTER}.course`, `${NPF_COURSE_MASTER}.specialization`],
        conditions: [`${NPF_COURSE_MASTER}.e_id = ?`, `${NPF_COURSE_MASTER}.active = 'Y'`],
        parameters: [e_id],
      };
      const npfCourseList = await getnpfCourses(queryFornpfCOurse);
      return {"thirdpartyapi":{"apicount":npfcred.length,"credential":npfcred,"course":npfCourseList} }
    }
    else
    {
      return {"thirdpartyapi":{"apicount":0}}
    }

  } catch (error) {
    throw new Error(error);
  }

};








const setCollegeCourses = async (e_id) => {
  try {
    const queryMapCollegeCourse = {
      attributes: [
        `${C_COURSE}.c_id`,
        `${CATEGORY}.cat_name AS course_category`,
        `${COURSE}.course_name AS course_name`,
        `${SPECIALIZATION}.spce_name AS specialization`,
        `${C_COURSE}.course_duration`,
        `${C_COURSE}.course_duration_type`,
        `${COURSE_DELIVERY}.name AS mode_learning`,
        `${COURSELEVEL}.name AS course_level`,
        `${C_COURSE}.course_fee`,
      ],
      conditions: [`${C_COURSE}.e_id = ?`],
      parameters: [e_id],
      joinTbl: [
        `LEFT JOIN ${COURSE} ON (${COURSE}.course_id = ${C_COURSE}.course_name OR ${COURSE}.course_name = ${C_COURSE}.course_name)`,
        `LEFT JOIN ${CATEGORY} ON (${CATEGORY}.cat_id = ${C_COURSE}.course_category OR ${CATEGORY}.cat_name = ${C_COURSE}.course_category)`,
        `LEFT JOIN ${SPECIALIZATION} ON (${SPECIALIZATION}.spec_id = ${C_COURSE}.specialization OR ${SPECIALIZATION}.spce_name = ${C_COURSE}.specialization)`,
        `LEFT JOIN ${COURSE_DELIVERY} ON (${COURSE_DELIVERY}.id = ${C_COURSE}.mode_learning OR ${COURSE_DELIVERY}.name = ${C_COURSE}.mode_learning)`,
        `LEFT JOIN ${COURSELEVEL} ON (${COURSELEVEL}.id = ${C_COURSE}.course_level OR ${COURSELEVEL}.name = ${C_COURSE}.course_level)`
      ],
      additional: [`GROUP BY ${C_COURSE}.c_id`]
    };
    const clgCoursesResult = await getCollegesCourseService(
      queryMapCollegeCourse
    );
    const courses = [] , pgCourses = [];
    clgCoursesResult.forEach((course) => {
      if (course.course_level === "PG Courses") {
        pgCourses.push(course);
      } else {
        courses.push(course);
      }
    });
    return { courses, pgCourses };
  } catch (error) {
    throw new Error(error);
  }
};


const setCollegeAwards = async (e_id) => {
  try {
    const queryMapCollegeAwards = {
      attributes: [`${TBL_AWARDS}.awd_title`, `${TBL_AWARDS}.awd_descriptipn`],
      conditions: [`${TBL_AWARDS}.e_id = ?`, `${TBL_AWARDS}.is_active = 'Y'`],
      parameters: [e_id],
    };
    const clgAwardsResult = await getCollegeAwardService(queryMapCollegeAwards);
    // console.log(clgAwardsResult);
    return clgAwardsResult;
  } catch (error) {
    throw new Error(error);
  }
};

const getPlacementCompany = async (placementCompanyList) => {
  if (!placementCompanyList) return [];
  try {
    const queryMap = {
      attributes: [
        `${COMPANY_PLACEMENT}.company_name`,
        `${COMPANY_PLACEMENT}.company_logo`,
      ],
      conditions: [`${COMPANY_PLACEMENT}.com_id IN (${placementCompanyList})`, `${COMPANY_PLACEMENT}.active = 'Y'`],
    };
    const { result } = await getCompanyPlacementPaginationService(queryMap);
    return result;
  } catch (error) {
    throw new Error(error);
  }
};



module.exports = {
  GetCustomLandingPageContent,
  getCollegesSearchForPublics,
};

const pushRequiredFilters = (query, { conditions, parameters, joinTbl }) => {
  const courseCategory = query.course_category;
  if (courseCategory) {
    conditions.push(`${C_COURSE}.course_category LIKE ?`);
    parameters.push(`%${courseCategory}%`);
  }

  const courseName = query.course_name;
  if (courseName) {
    conditions.push(
      `(${COURSE}.course_id = ? OR ${COURSE}.course_name LIKE ?)`
    );
    parameters.push(`${courseName}`, `%${courseName}%`);
    joinTbl.push(
      `LEFT JOIN ${COURSE} ON (${COURSE}.course_id = ${C_COURSE}.course_name OR ${COURSE}.course_name = ${C_COURSE}.course_name)`
    );
  }

  const spceName = query.spce_name;
  if (spceName) {
    conditions.push(
      `(${SPECIALIZATION}.spec_id = ? OR ${SPECIALIZATION}.spce_name LIKE ?)`
    );
    parameters.push(`${spceName}`, `%${spceName}%`);
    joinTbl.push(
      `LEFT JOIN ${SPECIALIZATION} ON (${SPECIALIZATION}.spec_id = ${C_COURSE}.specialization OR ${SPECIALIZATION}.spce_name = ${C_COURSE}.specialization)`
    );
  }

  const state = query.state;
  if (state) {
    conditions.push(`(${STATE_TBL}.sid = ? OR ${STATE_TBL}.state LIKE ?)`);
    parameters.push(`${state}`, `%${state}%`);
    joinTbl.push(
      `LEFT JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${C_CONTACT}.state OR ${STATE_TBL}.state = ${C_CONTACT}.state)`
    );
  }

  const city = query.city;
  if (city) {
    conditions.push(`(${CITY_TBL}.ctid = ? OR ${CITY_TBL}.cname LIKE ?)`);
    parameters.push(`${city}`, `%${city}%`);
    joinTbl.push(
      `LEFT JOIN ${CITY_TBL} ON (${CITY_TBL}.ctid = ${C_CONTACT}.city OR ${CITY_TBL}.cname = ${C_CONTACT}.city)`
    );
  }

  const courseDelivery = query.course_delivery;
  if (courseDelivery) {
    conditions.push(
      `(${COURSE_DELIVERY}.id = ? OR ${COURSE_DELIVERY}.name LIKE ?)`
    );
    parameters.push(`${courseDelivery}`, `%${courseDelivery}%`);
    joinTbl.push(
      `LEFT JOIN ${COURSE_DELIVERY} ON (${COURSE_DELIVERY}.id = ${C_COURSE}.mode_learning OR ${COURSE_DELIVERY}.name = ${C_COURSE}.mode_learning)`
    );
  }

  const collegeType = query.college_type;
  if (collegeType) {
    conditions.push(
      `(${INSTITUTE_TYPE}.id = ? OR ${INSTITUTE_TYPE}.name LIKE ?)`
    );
    parameters.push(`${collegeType}`, `%${collegeType}%`);
    joinTbl.push(
      `LEFT JOIN ${INSTITUTE_TYPE} ON (${INSTITUTE_TYPE}.id = ${C_INSTITUTE}.college_type OR ${INSTITUTE_TYPE}.name = ${C_INSTITUTE}.college_type)`
    );
  }

  const courseLevel = query.course_level;
  if (courseLevel) {
    conditions.push(`(${COURSELEVEL}.id = ? OR ${COURSELEVEL}.name LIKE ?)`);
    parameters.push(`${courseLevel}`, `%${courseLevel}%`);
    joinTbl.push(
      `LEFT JOIN ${COURSELEVEL} ON (${COURSELEVEL}.id = ${C_COURSE}.course_level OR ${COURSELEVEL}.name = ${C_COURSE}.course_level)`
    );
  }

  return null;
};

const setCollegesWithTopCourse = async (colleges, category) => {
  const collegesWithTopCourse = [];
  for (let i = 0; i < colleges.length; i++) {
    const college = colleges[i];
    const { e_id } = college;
    const queryMapCollegeCourse = {
      attributes: [
        `${C_COURSE}.course_name`,
        `${C_COURSE}.course_duration`,
        `${C_COURSE}.course_duration_type`,
        `${C_COURSE}.course_fee`,
        `${C_COURSE}.specialization`,
      ],
      conditions: [
        `${C_COURSE}.e_id = ?`,
        `(${C_COURSE}.course_category LIKE ? OR ${C_COURSE}.course_name LIKE ? OR ${C_COURSE}.course_name LIKE ?)`,
      ],
      parameters: [
        e_id,
        ...[
          `%${category}%`,
          `%${category}%`,
          `%${category.substring(0, 1) + "." + category.substring(1)}%`,
        ],
      ],
      additional: [`LIMIT 5`],
    };
    const courseResult = await getCollegesCourseService(queryMapCollegeCourse);
    collegesWithTopCourse.push({
      ...college,
      courses: courseResult,
    });
  }
  return collegesWithTopCourse;
};
