const {
  SCHOOL_DETAIL,
  TBL_AWARDS,
  TBL_ACCORDION_CONTENT,
  SC_SCHOOLCITYMASTER,
  SCHOOLTYPE,
  TBL_SCHOOL_GRADE_FEE,
} = require("../../../../models/tables");
const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const { getSchoolIdBasedOnUrl } = require("../../../../utils/leadAccessCheck");
const {
  getSchoolDetailsService,
  getSchoolAwardsService,
  getSchoolFaqService,
  getSchoolGradeFeeService,
  getsimilarschools,
} = require("../../../../services/school.service");
const {
  getSchoolTypeService,
} = require("../../../../services/master/schoolType.service");

 

const GetCustomLandingPageContentSchool = tryCatch(async (req, res) => {
  


  // let findschool='Orchids';


  // sql = "SELECT city from `school_detail` WHERE `school_name` like '%Orchids%' and active='Y' group by city order by city asc";
  // result = await dbQuery(sql);
  // if (result.length === 0) errorMsgEmpty("No data found", res);


  // const schoolDetails = result.pop();
  // schoolDetails.similarschools = [{name:"shani verma"}];
  
  // return res.status(200).json({
  //   success: true,
  //   data: schoolDetails,
  // });

 

    


  const queryMap = {};
  queryMap.attributes = [
    `${SCHOOL_DETAIL}.sid`,
    `${SCHOOL_DETAIL}.school_name AS name`,
    `${SCHOOL_DETAIL}.school_url AS url`,
    `${SCHOOL_DETAIL}.school_logo AS logo`,
    `${SCHOOL_DETAIL}.school_image AS mainImg`,
    `${SCHOOL_DETAIL}.school_type AS type`,
    `${SCHOOL_DETAIL}.year AS establish`,
    `${SCHOOL_DETAIL}.full_boarding_fee AS full_boarding_fee`,
    `${SCHOOL_DETAIL}.annual_fee AS annual_fee`,    
    `${SCHOOL_DETAIL}.school_affiliated`,
    `${SCHOOL_DETAIL}.admission_partner AS is_partner`,
    `${SCHOOL_DETAIL}.state`,
    `${SCHOOL_DETAIL}.city`,
  ];

  queryMap.conditions = [];
  queryMap.parameters = [];


  // and active='Y' group by city order by city asc

 

  
  queryMap.conditions.push(
    `active='Y' and  school_name like ?` 
    );
    queryMap.parameters.push(
      `%Orchids%`,
    );


    //SELECT city from `school_detail` WHERE `school_name` like '%Orchids%' and active='Y' group by city order by city asc"
     
   

  const schoolResult = await getSchoolDetailsService(queryMap);
  const sendData = {};
  

  
  sendData.schools = schoolResult;


   sql = "SELECT city,state from `school_detail` WHERE `school_name` like '%Orchids%' and active='Y' group by city order by city asc";
  result = await dbQuery(sql);
  

  sendData.citylist = result;

  
  return res.status(200).json({
    status: "success",
    data: sendData,
  });




});

const fixSchoolTypeIssue = async (type) => {
  try {
    //shani commented if (type.length === 0 || !type) return [];
    if ((type && type.length === 0) || !type) return [];

    const schoolType = type.split(",");
    const schoolTypeId = [];

    for (let i = schoolType.length - 1; i >= 0; i--) {
      if (Number(schoolType[i]) && Number(schoolType[i]) >= 0) {
        schoolTypeId.push(schoolType.pop());
      } else {
        break;
      }
    }

    if (schoolTypeId.length === 0) return type;

    const queryMap = {
      attributes: [`${SCHOOLTYPE}.name`],
      conditions: [`${SCHOOLTYPE}.school_id IN (${schoolTypeId.join(",")})`],
      parameters: [],
    };

    const result = await getSchoolTypeService(queryMap);

    return Array.from(new Set([...result.map((type) => type.name), ...schoolType])).join(", ");
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  GetCustomLandingPageContentSchool,
  fixSchoolTypeIssue,
};

const setSchoolAttributes = () => {
  const schoolAttributesArr = [];
  const metaAttributes = [
    `${SCHOOL_DETAIL}.metaDescription`,
    `${SCHOOL_DETAIL}.metaKeywords`,
    `${SCHOOL_DETAIL}.pageTitle`,
  ];
  schoolAttributesArr.push(...metaAttributes);
  const schoolAttributes = [
    `${SCHOOL_DETAIL}.sid`,
    `${SCHOOL_DETAIL}.school_name AS name`,
    `${SCHOOL_DETAIL}.school_logo AS logo`,
    `${SCHOOL_DETAIL}.school_image`,
    `${SCHOOL_DETAIL}.address`,
    `city.cityName AS city`,
    `state.cityName AS state`,
    `${SCHOOL_DETAIL}.location`,
    `${SCHOOL_DETAIL}.authorised_by`,
    `${SCHOOL_DETAIL}.counsellor`,
  ];
  schoolAttributesArr.push(...schoolAttributes);
  const schoolAboutAttributes = [
    `${SCHOOL_DETAIL}.about_school AS about`,
    `${SCHOOL_DETAIL}.addmission_process`,
  ];
  schoolAttributesArr.push(...schoolAboutAttributes);
  const schoolKeyStatsAttributes = [
    `${SCHOOL_DETAIL}.school_type AS type`,
    `${SCHOOL_DETAIL}.education_medium`,
    `${SCHOOL_DETAIL}.year AS establish`,
    `${SCHOOL_DETAIL}.school_category`,
    `${SCHOOL_DETAIL}.campus_size`,
    `${SCHOOL_DETAIL}.school_class`,
    `${SCHOOL_DETAIL}.school_affiliated AS approved_by`,
    `${SCHOOL_DETAIL}.str_student_no`,
    `${SCHOOL_DETAIL}.str_teacher_no`,
    `${SCHOOL_DETAIL}.admission_partner AS is_partner`,
  ];
  schoolAttributesArr.push(...schoolKeyStatsAttributes);
  const schoolFeeAttributes = [
    `${SCHOOL_DETAIL}.annual_fee`,
    `${SCHOOL_DETAIL}.estimated_annual_fee`,
    `${SCHOOL_DETAIL}.application_fee`,
    `${SCHOOL_DETAIL}.admission_fee`,
    `${SCHOOL_DETAIL}.security_fee`,
    `${SCHOOL_DETAIL}.other_fee`,
    `${SCHOOL_DETAIL}.tution_fee`,
    `${SCHOOL_DETAIL}.semi_boarding_fee`,
    `${SCHOOL_DETAIL}.full_boarding_fee`,
  ];
  schoolAttributesArr.push(...schoolFeeAttributes);
  const schoolMedaiAttributes = [
    `${SCHOOL_DETAIL}.upload_video1 AS video1`,
    `${SCHOOL_DETAIL}.upload_video2 AS video2`,
    `${SCHOOL_DETAIL}.upload_video3 AS video3`,
    `${SCHOOL_DETAIL}.upload_video4 AS video4`,
    `${SCHOOL_DETAIL}.upload_video5 AS video5`,
    `${SCHOOL_DETAIL}.upload_video6 AS video6`,
    `${SCHOOL_DETAIL}.upload_photo1 AS image1`,
    `${SCHOOL_DETAIL}.upload_photo2 AS image2`,
    `${SCHOOL_DETAIL}.upload_photo3 AS image3`,
    `${SCHOOL_DETAIL}.upload_photo4 AS image4`,
    `${SCHOOL_DETAIL}.upload_photo5 AS image5`,
    `${SCHOOL_DETAIL}.upload_photo6 AS image6`,
  ];
  schoolAttributesArr.push(...schoolMedaiAttributes);
  const schoolInfraAttributes = [
    `${SCHOOL_DETAIL}.infrastructure`,
    `${SCHOOL_DETAIL}.facilities`,
  ];
  schoolAttributesArr.push(...schoolInfraAttributes);
  const schoolExtraFacilitiesAttributes = [
    `${SCHOOL_DETAIL}.school_provide_meal`,
    `${SCHOOL_DETAIL}.cctvsurveillance`,
    `${SCHOOL_DETAIL}.classairconditioned`,
    `${SCHOOL_DETAIL}.str_student_no`,
    `${SCHOOL_DETAIL}.str_teacher_no`,
    `${SCHOOL_DETAIL}.totol_school_strength`,
    `${SCHOOL_DETAIL}.avgstudentperclass`,
    `${SCHOOL_DETAIL}.cocurricular_activities`,
  ];
  schoolAttributesArr.push(...schoolExtraFacilitiesAttributes);
  return schoolAttributesArr;
};
