const {dbQuery} = require("../../../config/db.config");
const { LANDING_PAGE } = require("../../../models/tables");
const tryCatch = require("../../../utils/tryCatch");

const table = LANDING_PAGE;

// @desc Post enquiry from landing page
// @route POST /api/v1/open/enquiry/partner-enquiry
// @access Private
const post_partnerEnquiry = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
    const {
      name,
      email,
      mobile = null,
      designation = null,
      institutename = null,
      institute_type = null,
      lookingfor = null,
      city = null,
      alloted_advrt_bdgt = null,
      querydetail = null,
    } = req.body;
    if (!name || !email)
      throw new Error("Name and email required fields are missing");
    sql = `INSERT INTO ${table} (name, email, phone, designation, institute_name, institute_type, looking_for, city, alloted_advrt_bdgt, querydetail, qry_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
    result = await dbQuery(sql, [
      name,
      email,
      mobile,
      designation,
      institutename,
      institute_type,
      lookingfor,
      city,
      alloted_advrt_bdgt,
      querydetail,
    ]);
    if (!result.affectedRows) throw new Error("Error! cant post partner enquiry");
    return res
      .status(200)
      .json({ success: true, message: "Enquiry posted successfully" });

  });
  
  module.exports = {
    post_partnerEnquiry,
  }