const tryCatch = require("../../../utils/tryCatch");
const { TBL_FREELY_ENQUIRY, TBL_FOOTER_CAREER_ENQ } = require("../../../models/tables");
const { areAllKeysPresent } = require("../../../utils/common_utils");
const { addNewEnquiryService } = require("../../../services/enquiry.service");
const { getSinglevalueByid }  = require("../../../utils/leadAccessCheck")
const openapply = require("../../../middlewares/openapplyperform");



// @desc post freely enquiry list
// @api POST /api/v1/open/enquiry/career-enquiry
// @access Private
const post_freelyEnquiry = tryCatch(async (req, res) => {

  const requiredFields = requiredFieldsForEnquiry().careerRequiredFields;
  if(!areAllKeysPresent(req.body, requiredFields)){
    res.statusCode = 400;
    throw new Error("Some fields are missing")
  }

  const queryMap = {
    table: TBL_FREELY_ENQUIRY,
    attributes: [...requiredFieldsForEnquiry().careerAttributes, "date", "active"],
    parameters: [...requiredFieldsForEnquiry().careerAttributes.map((field) => req.body[field]), new Date(), "Y"]
  }

  const result = await addNewEnquiryService(queryMap);

  
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while adding your Enquiry, We are fixing this...")
  }


  

  const statename = await getSinglevalueByid("state","state_tbl","sid",req.body["state"]);
  const course = await getSinglevalueByid("career_name","career_list","content_id",req.body["course"]);

  let insertId=result.insertId;
  

  const insertvalue={
    name:req.body["fullname"], 
    email:req.body["email"], 
    country_code:"+91", 
    mobile:req.body["contact"], 
    state:statename.state, 
    city:"", 
    college_name:"", 
    castecategory:"", 
    father:"", 
    course:course.career_name, 
    specialization:"",
    insertid:insertId,
    neetscore:""
  }
  
const updateval={updatecol:"npf_response",table:"tbl_freely_enquiry",updatekey:"id",updateid:insertId}
const resptd= openapply.addopenapply(insertvalue,updateval)


  return res.status(200).json({
    success: true,
    message: "Your enquiry has been submitted successfully. We will contact you shortly"
  })

});

// @desc post footer enquiry list from career
// @api POST /api/v1/open/footer-enquiry
// @access Private
const post_footerEnquiry = tryCatch(async (req, res) => {
 
 

  const requiredFields = requiredFieldsForEnquiry().footerEnqRequiredFields;
  if(!areAllKeysPresent(req.body, requiredFields)){
    res.statusCode = 400;
    throw new Error("Some required fields are missing");
  }

  const queryMap = {
    table: TBL_FOOTER_CAREER_ENQ,
    attributes: [...requiredFieldsForEnquiry().footerEnqAttributes, "date", "ipaddress"],
    parameters:[...requiredFieldsForEnquiry().footerEnqAttributes.map((field) => req.body[field]), new Date(), req.ip]
  };

  const result = await addNewEnquiryService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while adding you Enquiry, We are fixing this...");
  };

  return res.status(200).json({
    success: true,
    message: "Your enquiry has been submitted successfully. We will contact you shortly"
  })

});

module.exports = {
  post_freelyEnquiry,
  post_footerEnquiry,
};


const requiredFieldsForEnquiry = () => {
  return {
    careerAttributes: ["fullname", "email", "contact", "city", "state", "page_url", "message", "raw", "sms_count", "course", "npf_response"],
    careerRequiredFields: ["fullname", "email", "contact", "raw"],
    footerEnqAttributes: ["name", "email", "contact", "stream", "state", "city", "level", "course", "specialization", "npf_response"],
    footerEnqRequiredFields: ["name", "email", "contact", "stream"],
  }
}