const {dbQuery} = require("../../../config/db.config");
const { TBL_CONTACT } = require("../../../models/tables");
const tryCatch = require("../../../utils/tryCatch");

const table = TBL_CONTACT;



const {
  getContactPaginationService,
} = require("../../../services/college.service");

// @desc Post enquiry from landing page
// @route POST /api/v1/open/enquiry/partner-enquiry
// @access Private
const post_contactEnq = tryCatch(async (req, res) => {


  
  let [sql, result] = [null, null];
    const {
      name,
      email,
      contact = null,
      city= null,
      reason_reachout= null,
      message= null,
      company= null,
      notification_status=true
    } = req.body;
    if (!name || !email)
      throw new Error("Name and email required fields are missing");
    sql = `INSERT INTO ${table} (name,company,email,contact,reason_reachout,city,message,notification_status,date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
    result = await dbQuery(sql, [
      name,
      email,
      contact,
      city,
      reason_reachout,
      message,
      company,
      notification_status
    ]);
    if (!result.affectedRows) throw new Error("Error! cant post partner enquiry");
    return res
      .status(200)
      .json({ success: true, message: "Enquiry posted successfully" });

  });
  
  // const get_contactEnq = tryCatch(async (req, res) => {
  //   return res
  //   .status(200)
  //   .json({ success: true, message: "Enquiry posted successfully" });

  // })

  const get_contactEnq = tryCatch(async (req, res) => {
    const getProjectDetailsAttribute = () => {
      return {
        attributes: [
          `${TBL_CONTACT}.id`,
          `${TBL_CONTACT}.name`,
          `${TBL_CONTACT}.company`,
          `${TBL_CONTACT}.email`,
          `${TBL_CONTACT}.contact`,
          `${TBL_CONTACT}.reason_reachout`,
          `${TBL_CONTACT}.city`,
          `${TBL_CONTACT}.message`,
          `${TBL_CONTACT}.date`,
          `${TBL_CONTACT}.notification_status`,
        ],
      };
    };
  
    const { page = 1, limit = 10, search, pid } = req.query;
  
    
  
    if (Number(page) < 1)
      throw new Error("Page number is required and should be greater than 0");
    const offset = Number((page - 1) * 10);
  
    const queryMap = {
      attributes: getProjectDetailsAttribute().attributes,
      conditions: [],
      parameters: [],
      joinTbl: [
        // `LEFT JOIN ${TBL_PROJECT_CATEGORY} ON ${TBL_PROJECT_CATEGORY}.id = ${TBL_PROJECTS}.project_cat`,
        // `LEFT JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${C_CONTACT}.state OR ${STATE_TBL}.state = ${C_CONTACT}.state)`,
        // `LEFT JOIN ${CITY_TBL} ON (${CITY_TBL}.ctid = ${C_CONTACT}.city OR ${CITY_TBL}.cname = ${C_CONTACT}.city)`
      ],
      additional: [
        // `GROUP BY ${TBL_PROJECTS}.e_id`,
        `ORDER BY ${TBL_CONTACT}.id asc`,
        `LIMIT ${Number(limit) || 10} OFFSET ${offset}`,
      ],
      distinctCount: `${TBL_CONTACT}.id`,
    };
  
  
    // if (search) {
    //   queryMap.conditions.push(`${TBL_PROJECT_CATEGORY}.project_name LIKE ?`);
    //   queryMap.parameters.push(`%${search.replace(/-/g, ' ')}%`);
    // }
  
   
    const { result, total } = await getContactPaginationService(queryMap);
  
    return res.status(200).json({
      status: true,
      data: result,
      records: total,
    });
  });
  
  module.exports = {
    post_contactEnq,
    get_contactEnq,
  }