const {dbQuery} = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const { ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY } = require("../../../models/tables");

const table = ENTRANCE_EXAMS_GET_NOTIFICATIONQUERY;

// @desc Post exam Enquiry
// @route POST /api/v1/open/enquiry/exam
// @access Private
const post_examEnquiry = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
    const {
      inputname,
      inputemail,
      inputemobile,
      current_url,
      inputstate,
      entrance_exam_name,
      entrance_exam_url,
    } = req.body;
    if (
      !inputname ||
      !inputemail ||
      !current_url ||
      !entrance_exam_name ||
      !entrance_exam_url ||
      !inputemobile ||
      !inputstate
    )
      throw new Error("Invalid data");
    sql = `INSERT INTO ${table} (inputname, inputemail, inputemobile, current_url, inputstate, entrance_exam_name, entrance_exam_url, date) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())`;
    result = await dbQuery(sql, [
      inputname,
      inputemail,
      inputemobile,
      current_url,
      inputstate,
      entrance_exam_name,
      entrance_exam_url,
    ]);
    return res.status(200).json({
      success: true,
      message: "exam enquiry submitted successfully",
    });
  });

  module.exports = {
    post_examEnquiry,
  }