const { dbQuery } = require("../../../config/db.config");
const { TBL_FREE_COUNSELLING } = require("../../../models/tables");
const tryCatch = require("../../../utils/tryCatch");
const { errorMsgEmpty } = require("../../../utils/errors_message");

const table = TBL_FREE_COUNSELLING;

// @desc Post enquiry from landing page
// @route POST /api/v1/open/enquiry/partner-enquiry
// @access Private

const get_existing_enq = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let qry = "";
  let { page, limit = 50, search } = req.query;
  if (!page || page < 1)
    throw new Error(`Page number is required and should be greater than 0`);
  const offset = (page - 1) * limit;
  if (search)
    qry += `WHERE name LIKE '${search}%' OR email LIKE '${search}%' OR mobile LIKE '${search}%'`;
  //sql = `SELECT * FROM ${table} ${qry} order by date desc LIMIT ${limit} OFFSET ${offset}`;

  // sql = `SELECT
  // tc.sl,
  // tc.name,
  // tc.email,
  // tc.mobile,
  // tc.message,
  // tc.date,
  // (select cat_name from category where cat_id=tc.stream) as category,
  // (select course_name from course where course_id=tc.course) as course,
  // (select spce_name from specialization where spec_id=tc.specialization) as specialization,
  // (select cname from city_tbl where ctid=tc.city) as city,
  // (select state from state_tbl where sid=tc.state) as state
  // FROM ${table} as tc
  // ${qry}
  // order by sl desc LIMIT ${limit} OFFSET ${offset}`;

sql = `SELECT DISTINCT 
sc_user.us_fname as name, 
sc_user.us_username as email,
sc_user.mobile_1 as mobile,
engineering_institute_course.course_category as category,
engineering_institute_course.course_name as course,
engineering_institute_course.specialization as specialization,
tbl_school_shortlist.id, 
tbl_school_shortlist.date, 
tbl_school_shortlist.school_id, engineering_institute.institute_name, 
engineering_institute.institute_logo, tbl_common_application_form.form_status, 
tbl_common_application_form.id AS common_form_id FROM tbl_school_shortlist 
INNER JOIN engineering_institute ON engineering_institute.e_id = tbl_school_shortlist.school_id 
INNER JOIN tbl_common_application_form ON tbl_common_application_form.e_id = tbl_school_shortlist.school_id 
INNER JOIN engineering_institute_course ON tbl_school_shortlist.c_id =  engineering_institute_course.c_id
INNER JOIN sc_user ON sc_user.us_id = tbl_school_shortlist.us_id 
AND tbl_common_application_form.us_id = tbl_school_shortlist.us_id 
WHERE 1 AND tbl_school_shortlist.usertype = 'partner' and tbl_school_shortlist.source ='enq' group by tbl_school_shortlist.id order by tbl_school_shortlist.id desc LIMIT ${limit} OFFSET ${offset}`;

result = await dbQuery(sql);

  
  
  if (result.length === 0) {
    // errorMsgEmpty("No data found", res);
    return res.status(200).json({ success: false, message:"No data found"});

  }

  const { records } = { records: result.length };
  return res.status(200).json({ success: true, data: result, records });
});

const post_freecounsell = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const {
    name,
    email,
    mobile = null,
    state = null,
    city = null,
    selectedCategoryId = null,
    selectedCourseId = null,
    selectedSpecialization = null,
    message = null,
  } = req.body;
  if (!name || !email)
    throw new Error("Name and email required fields are missing");
  sql = `INSERT INTO ${table} (name, email, mobile, state, city, stream, course, specialization, message, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
  result = await dbQuery(sql, [
    name,
    email,
    mobile,
    state,
    city,
    selectedCategoryId,
    selectedCourseId,
    selectedSpecialization,
    message,
  ]);
  if (!result.affectedRows) throw new Error("Error! cant post partner enquiry");
  return res
    .status(200)
    .json({ success: true, message: "Enquiry posted successfully" });
});

module.exports = {
  post_freecounsell,
  get_existing_enq,
};
