const {dbQuery} = require("../../../config/db.config");
const { TBL_FREE_COUNSELLING } = require("../../../models/tables");
const tryCatch = require("../../../utils/tryCatch");

const table = TBL_FREE_COUNSELLING;

// @desc Post enquiry from landing page
// @route POST /api/v1/open/enquiry/partner-enquiry
// @access Private


const get_freecounsell = tryCatch(async (req, res) => {

  
  let [sql, result] = [null, null];
  let qry = "";
  let { page, limit = 50, search } = req.query;
  if (!page || page < 1)
    throw new Error(`Page number is required and should be greater than 0`);
  const offset = (page - 1) * limit;
  if (search) qry += `WHERE name LIKE '${search}%' OR email LIKE '${search}%' OR mobile LIKE '${search}%'`;
  //sql = `SELECT * FROM ${table} ${qry} order by date desc LIMIT ${limit} OFFSET ${offset}`;


  sql = `SELECT 
  tc.sl,
  tc.name,
  tc.email,
  tc.mobile,
  tc.message,
  tc.date,
  (select cat_name from category where cat_id=tc.stream) as category,
  (select course_name from course where course_id=tc.course) as course,
  (select spce_name from specialization where spec_id=tc.specialization) as specialization,
  (select cname from city_tbl where ctid=tc.city) as city,
  (select state from state_tbl where sid=tc.state) as state
  FROM ${table} as tc
  ${qry} 
  order by sl desc LIMIT ${limit} OFFSET ${offset}`;
   



//   SELECT 

// tc.sl,
// tc.name,
// tc.email,
// tc.mobile,
// st.state,
// ct.cname,
// cat.cat_name,
// cs.course_name,
// spcz.spce_name,
// tc.message,
// tc.date
// FROM tbl_counselling_data_shani as tc 
// JOIN city_tbl as ct ON tc.city = ct.ctid 
// JOIN state_tbl as st ON tc.state = st.sid 
// JOIN category as cat ON cat.cat_id = tc.stream 
// JOIN course as cs ON cs.course_id = tc.course

// JOIN specialization  as spcz ON spcz.spec_id=tc.specialization

  
  
  result = await dbQuery(sql);
  if (result.length === 0) errorMsgEmpty("No data found", res);
  const total = await dbQuery(`SELECT COUNT(*) as records FROM ${table} ${qry}`);
  const { records } = total[0];
  return res.status(200).json({ success: true, data: result, records });
});



const post_freecounsell = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
    const {

      name,
      email,
      mobile = null,
      state= null,
      city= null,
      selectedCategoryId= null,
      selectedCourseId= null,
      selectedSpecialization= null,
      message= null,
    } = req.body;
    if (!name || !email)
      throw new Error("Name and email required fields are missing");
    sql = `INSERT INTO ${table} (name, email, mobile, state, city, stream, course, specialization, message, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
    result = await dbQuery(sql, [
      name,
      email,
      mobile,
      state,
      city,
      selectedCategoryId,
      selectedCourseId,
      selectedSpecialization,
      message,
      
    ]);
    if (!result.affectedRows) throw new Error("Error! cant post partner enquiry");
    return res
      .status(200)
      .json({ success: true, message: "Enquiry posted successfully" });

  });
  
  module.exports = {
    post_freecounsell,
    get_freecounsell  

  }