const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const { STUDY_INDIA } = require("../../../models/tables");
const { transporter } = require("../../admin/CMS/EmailTemplate/email");
const axios = require("axios");

const {
  getschoolemailbyid,
  getSinglevalueByid,
  NPFResponseUpdatebytable,
  NPFResponseUpdate
} = require("../../../utils/leadAccessCheck");


const table = STUDY_INDIA;
const { EMAIL_FROM } = process.env;

// @desc Post study india Enquiry
// @route POST /api/v1/open/enquiry/studyindia
// @access Private
const post_studyindiaEnquiry = tryCatch(async (req, res) => {


  
  let [sql, result] = [null, null];
  const {
    school_id = null,
    study_preference = null,
    edu_interest = null,
    des_course = null,
    plan_start = null,
    name,
    parent_name = null,
    email,
    mobile,
    city = null,
    state = null,
    location = null,
    school_grade = null,
    school_type = null,
    child_dob = null,
    // current_location = null,
    current_location = state+" / "+city,
    affiliated = null,
    currentpageurl = null,
    higher_qualification = null,
    user_query = null,
    course_category = null,
    message = null,
    answer = null,
    query_type = null,
    ip_address = null,
    // post_date = null,
    status = null,
    mailsent = 0,
    parent_query = 0,
    admin_reply = 0,
    // remark = null,
    // remark_cause = null,
    // remark_date = null,
    unsubscribe = null,
    budget = null,
  } = req.body;

 
  const now =  new Date().toLocaleString("en", { timeZone: "Asia/Calcutta" })
  
  
  if (!name || !email || !mobile)
    throw new Error("Some required fields are missing");
  sql = `INSERT INTO ${table} (school_id, study_preference, edu_interest, des_course, plan_start, name, parent_name, email, mobile, city, location, school_grade, school_type, child_dob, current_location, affiliated, currentpageurl, higher_qualification, user_query, course_category, message, answer, query_type, ip_address, status, mailsent, parent_query, admin_reply, unsubscribe, budget,post_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '${now}')`;
  result = await dbQuery(sql, [
    school_id,
    study_preference,
    edu_interest,
    des_course,
    plan_start,
    name,
    parent_name,
    email,
    mobile,
    city,
    location,
    school_grade,
    school_type,
    child_dob,
    current_location,
    affiliated,
    currentpageurl,
    higher_qualification,
    user_query,
    course_category,
    message,
    answer,
    query_type,
    ip_address,
    status,
    mailsent,
    parent_query,
    admin_reply,
    unsubscribe,
    budget
  ]);

  const lastinsert = result.insertId;


  
  const eid = await getSinglevalueByid(
    "eid",
    "tbl_npf_api",
    "eid",
    req.body.school_id
  );

  let gradelist = [
    { key: "Pre-Nursery", value: "35" },
    { key: "Nursery", value: "36" },
    { key: "K1", value: "37" },
    { key: "Grade 1", value: "39" },
    { key: "Grade 2", value: "40" },
    { key: "Grade 3", value: "41" },
    { key: "Grade 4", value: "42" },
    { key: "Grade 5", value: "43" },
    { key: "Grade 6", value: "44" },
    { key: "Grade 7", value: "45" },
    { key: "Grade 8", value: "46" },
    { key: "K2", value: "38" },
    { key: "Grade 9", value: "47" },
    { key: "Grade 11", value: "51" },
    { key: "Grade 10", value: "48" },
    { key: "Long Term (LT)", value: "68" },
    { key: "Grade 12", value: "52" },
    { key: "Daycare", value: "53" },
    { key: "II PUC Commerce CEBA", value: "57" },
    { key: "II PUC Commerce SEBA", value: "56" },
    { key: "I PUC Commerce SEBA", value: "55" },
    { key: "I PUC Commerce CEBA", value: "54" },
    { key: "I PU Commerce EBAS", value: "58" },
    { key: "I PU Commerce EBAC", value: "59" },
    { key: "I PU Commerce EBABM", value: "60" },
    { key: "I PU Commerce HEBA", value: "61" },
    { key: "I PU Commerce MSBA", value: "62" },
    { key: "II PU Commerce EBAS", value: "63" },
    { key: "I PU COMMERCE EMBS", value: "105" },
    { key: "II PU Commerce EBAC", value: "64" },
    { key: "II PU Commerce EBABM", value: "65" },
    { key: "II PU COMMERCE EBMS", value: "106" },
    { key: "II PU Commerce HEBA", value: "66" },
    { key: "II PU Commerce MSBA", value: "67" },
    { key: "I PU COMMERCE ABMS", value: "107" },
    { key: "II PU COMMERCE ABMS", value: "108" },
    { key: "I PU COMMERCE ABSC", value: "109" },
    { key: "II PU COMMERCE ABSC", value: "110" },
    { key: "I PU COMMERCE ABEM", value: "111" },
    { key: "II PU COMMERCE ABEM", value: "112" },
  ];

  let filtgrade = gradelist.filter((d) => d.key == req.body.grade);
  let studentgrade = null;

  if (filtgrade.length > 0) {
    studentgrade = filtgrade[0].value;
  } else {
    studentgrade = 45;
  }

  const branch = await getSinglevalueByid(
    "branch",
    "tbl_npf_api",
    "eid",
    eid.eid
  );

  const branchids = await getSinglevalueByid(
    "branch_id",
    "tbl_npf_api",
    "eid",
    eid.eid
  );

  const college_name = await getSinglevalueByid(
    "college_name",
    "tbl_npf_api",
    "eid",
    eid.eid
  );

  const secret_key = await getSinglevalueByid(
    "secret_key",
    "tbl_npf_api",
    "eid",
    eid.eid
  );

  const api = await getSinglevalueByid("api", "tbl_npf_api", "eid", eid.eid);

  var postData = {
    "Access-Api-Key": secret_key.secret_key,
    lead_name: req.body.name,
    phone_no: mobile,
    email_id: email,
    gender: "M",
    // grade: req.body.grade,
    grade: studentgrade,
    school: college_name.college_name
      ? college_name.college_name
      : req.body.school,
    branch_name: branch.branch,
    branch_id: branchids.branch_id,
    user_id: "906885",
    academic_year: "2025-26",
    is_boarding: req.body.is_boarding == "Boarding School" ? true : false,
  };


  
  

  axios.post(`${api.api}`, postData).then((response) => {
    // sourcetalbe:sourctable,
    // perspectivecolumn:perspectivecolumn

    // console.log("response",response.data)

    const openupdate = NPFResponseUpdatebytable(
      "npf_response",
      'study_india',
      's_id',
      lastinsert,
      response.data
    );

    // const openupdate = NPFResponseUpdatebytable(
    //   "npf_response",
    //   "sc_user",
    //   "us_id",
    //   lastinsert,
    //   response.data
    // );

    const npfupdate = NPFResponseUpdate(
      postData,
      response.data,
      'study_india',
      lastinsert,
      eid.eid,
      college_name.college_name
    );


    

   
      // return res.status(200).json({
      //   success: response.data.status ? response.data.status : response.data,
      //   message: response.data.message ? response.data.message : response.data,
      // });
    
  });
 
if(name && email && mobile && req.body.school_id){

  function padFunction(number,slie) {
    let string = String(number)
    let sliced = string.slice(Number(slie));	
    let mask = String(sliced).padStart(string.length, "*")
    return mask;
  }

  const emailids = await getschoolemailbyid(
    req.body.school_id
  );


  let mailcontent= `<body style="font-family:Verdana, Arial, Helvetica, sans-serif">
	<table width="600px" style="border:5px solid #f0f1f4; border-collapse:collapse; margin:0 auto; text-align:center;">
		<tr>
			<td colspan="3" style="display:block; text-align:center; background:#fff; border-bottom:2px solid #4242FF; padding:10px 0;"><a href="#"><img src="https://www.allschoolscolleges.com/red-logo.png" width="200px"   /></a></td>
		</tr>
		<tr>
			<td colspan="3">
				<h2>Student / Parent Details</h2>
				<b>Enquiry for Admission <br/> ${emailids.school_name}</b>
				<br />
				<table width="400px" align="center" cellpadding="2" cellspacing="4" bgcolor="#f4f4f4" style="text-align:left;">
					<tr>
						<td><b>Name</b></td>
						<td>:</td>
						<td>${name}</td>
					</tr>
					<tr>
						<td><b>Email</b></td>
						<td>:</td>
						<td>${padFunction(email,-16)}</td>
					</tr>
					<tr>
						<td><b>Contact</b></td>
						<td>:</td>
						<td>${padFunction(mobile,-4)}</td>
					</tr>
					<tr>
						<td><b>School Grade</b></td>
						<td>:</td>
						<td>${school_grade}</td>
					</tr>
					<tr>
						<td><b>City</b></td>
						<td>:</td>
						<td>${city}</td>
					</tr>
				</table>
				<br />
			</td>
		</tr>
		<tr>
			<td colspan="3" style=" background:#f0f1f4;">&nbsp;</td>
		</tr>
		<tr>
			<td style="text-align:center;" colspan="3">
				<br />
				<b style="font-size:20px;">Become admission partner with <a href="https://www.allschoolscolleges.com/" target="_blank">Allschoolscolleges.com</a> and <br /> Get More Admission</b>
				<br /><br />
				<a href="https://www.allschoolscolleges.com/education-crm/" target="_blank" style="background: #de5753; color: #fff; text-align: center; padding: 3px 10px; border-radius:22px; font-size: 14px; text-decoration: none;">Click here to become a partner</a>
				<br />
				<br />
			</td>
		</tr>
		<tr>
			<td colspan="3" style=" background:#f0f1f4;">&nbsp;</td>
		</tr>
		 
		<tr>
			<td colspan="3" style="background:#f0f1f4; padding:20px; border-bottom:1px solid #CFCCCC;">
				<ul style="display:block; margin:0 auto; padding:0px;">
					<li style="display:inline; padding:0 4px; margin:0px;"><a href="https://www.facebook.com/allschoolscolleges"><img  width="20px"  src="https://www.allschoolscolleges.com/facebook.png" /></a></li>
					<li style="display:inline; padding:0 4px; margin:0px;"><a href="https://twitter.com/allschoolscoleg"><img width="20px"  src="https://www.allschoolscolleges.com/twitter.png" /></a></li>
					<li style="display:inline; padding:0 4px; margin:0px;"><a href="https://www.linkedin.com/school/allschoolscolleges/"><img width="20px"  src="https://www.allschoolscolleges.com/linkedin.png" /></a></li>
					<li style="display:inline; padding:0 4px; margin:0px;"><a href="https://www.youtube.com/c/allschoolscolleges"><img width="20px"  src="https://www.allschoolscolleges.com/youtube.png" /></a></li>
				</ul>
			</td>
		</tr>

		<tr>
			<td colspan="3" style="background:#f0f1f4; padding:20px; border-bottom:1px solid #D4D3D3;">
				<p style="font-size:11px;">
					Best Regards<br />
					Team <br />
					www.AllSchoolsColleges.com<br />
					Mob:+91 77038 65712<br />
          connect@allschoolscolleges.com<br />
					The Elementary to higher Education Hub<br />
				</p>
			</td>
		</tr>
	</table>
</body>`;

let mails= emailids.emailids
//  console.log("emailids.emailids",mails)
   
var mailOptions = {
  from: EMAIL_FROM,    // sender address
  // to: 'shani.intactadvt@gmail.com, iamsmartsunny@gmail.com', // list of receivers
  to: mails, // list of receivers
  subject: `Parent Enquire for ${emailids.school_name} :: From Allschoolscolleges.com`, // Subject line
  // text: 'Hello world from Node.js',       // plaintext body
  html: mailcontent // html body
};
 


transporter.sendMail(mailOptions, function (error, info) {
    if (error) {
      // return res.status(500).json({
      //   success: false,
      //   message: "Email not sent",
      //   error: error,
      // });
    }
  });

}


   
   
  if (!result.affectedRows) throw new Error("Failed to insert data");
  return res.status(200).json({
    success: true,
    message: "Data inserted successfully",
  });
});

module.exports = {
    post_studyindiaEnquiry,
}
