const { TBL_EXAM_COURSE, EXAM_LEVEL_TYPE, COURSELEVEL } = require("../../../models/tables");
const { getExamsByCategoryIdService } = require("../../../services/exam.service");
const tryCatch = require("../../../utils/tryCatch");

//@desc get one exam details for public by exam url
//@route GET /api/v1/public/exams/:examUrl
//@access PUBLIC
const getExamDetailsForPublic = tryCatch(async (req, res) => {
  const { examUrl } = req.params;

  const queryMap = {};
  queryMap.attributes = [`${TBL_EXAM_COURSE}.*`, `${EXAM_LEVEL_TYPE}.name as level`, `${COURSELEVEL}.name as exam_level`];
  queryMap.conditions = [
    `${TBL_EXAM_COURSE}.exam_url = ?`,
    `${TBL_EXAM_COURSE}.active = 'Y'`,
  ];
  queryMap.parameters = [examUrl];
  queryMap.additional = [`LIMIT 1`];
  queryMap.joinTbl = [
    `LEFT JOIN ${EXAM_LEVEL_TYPE} ON (${EXAM_LEVEL_TYPE}.id = ${TBL_EXAM_COURSE}.level OR ${EXAM_LEVEL_TYPE}.name = ${TBL_EXAM_COURSE}.level)`,
    `LEFT JOIN ${COURSELEVEL} ON (${COURSELEVEL}.id = ${TBL_EXAM_COURSE}.exam_level OR ${COURSELEVEL}.name = ${TBL_EXAM_COURSE}.exam_level)`
  ];

  const result = await getExamsByCategoryIdService(queryMap);
  if (result instanceof Error || result.length === 0) {
    res.statusCode = 404;
    throw new Error("No data found");
  }

  return res.status(200).json({
    status: "success",
    message: "Exam details fetched successfully",
    data: result[0],
  });
  
});

module.exports = { getExamDetailsForPublic };